/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ExtendedResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.LegacyBundleResourceRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.util.LibLoaderResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class MasterReport
extends AbstractReportDefinition {
    public static final String REPORT_DATE_PROPERTY = "report.date";
    private DataFactory dataFactory;
    private HierarchicalConfiguration reportConfiguration;
    private transient ResourceManager resourceManager;
    private ReportParameterDefinition parameterDefinition;
    private ReportEnvironment reportEnvironment;
    private ReportParameterValues parameterValues;
    private ResourceBundleFactory resourceBundleFactory;

    public MasterReport() {
        this.setElementType(new MasterReportType());
        this.setResourceBundleFactory(new LibLoaderResourceBundleFactory());
        this.reportConfiguration = new HierarchicalConfiguration(ClassicEngineBoot.getInstance().getGlobalConfig());
        this.parameterValues = new ReportParameterValues();
        this.setPageDefinition(null);
        TableDataFactory dataFactory = new TableDataFactory();
        dataFactory.addTable("default", new DefaultTableModel());
        this.dataFactory = dataFactory;
        this.setQuery("default");
        this.addReportModelListener(new DocumentBundleChangeHandler());
        this.reportEnvironment = new DefaultReportEnvironment(this.getConfiguration());
        this.parameterDefinition = new DefaultParameterDefinition();
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        documentBundle.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.reporting.classic");
        documentBundle.getWriteableDocumentMetaData().setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)new Date());
        this.setBundle((DocumentBundle)documentBundle);
        this.setContentBase(documentBundle.getBundleMainKey());
        this.addReportModelListener(new ResourceBundleChangeHandler());
        this.updateResourceBundleFactoryInternal();
    }

    public static ResourceBundleFactory computeAndInitResourceBundleFactory(ResourceBundleFactory resourceBundleFactory, ReportEnvironment environment) {
        if (!(resourceBundleFactory instanceof ExtendedResourceBundleFactory)) {
            return resourceBundleFactory;
        }
        ExtendedResourceBundleFactory rawResourceBundleFactory = (ExtendedResourceBundleFactory)resourceBundleFactory;
        try {
            ExtendedResourceBundleFactory extendedResourceBundleFactory = (ExtendedResourceBundleFactory)rawResourceBundleFactory.clone();
            if (extendedResourceBundleFactory.getLocale() == null) {
                extendedResourceBundleFactory.setLocale(environment.getLocale());
            }
            if (extendedResourceBundleFactory.getTimeZone() == null) {
                extendedResourceBundleFactory.setTimeZone(environment.getTimeZone());
            }
            return extendedResourceBundleFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cannot clone resource-bundle factory");
        }
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        ArgumentNullException.validate((String)"resourceBundleFactory", (Object)resourceBundleFactory);
        this.resourceBundleFactory = resourceBundleFactory;
        this.notifyNodePropertiesChanged();
    }

    public DocumentBundle getBundle() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "bundle");
        if (o instanceof DocumentBundle) {
            return (DocumentBundle)o;
        }
        return null;
    }

    public void setBundle(DocumentBundle bundle) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "bundle", bundle);
    }

    public ReportParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    public void setParameterDefinition(ReportParameterDefinition parameterDefinition) {
        if (parameterDefinition == null) {
            throw new NullPointerException();
        }
        this.parameterDefinition = parameterDefinition;
        this.notifyNodePropertiesChanged();
    }

    public ModifiableReportParameterDefinition getModifiableParameterDefinition() {
        if (this.parameterDefinition instanceof ModifiableReportParameterDefinition) {
            return (ModifiableReportParameterDefinition)this.parameterDefinition;
        }
        return null;
    }

    public ReportEnvironment getReportEnvironment() {
        return this.reportEnvironment;
    }

    public void setReportEnvironment(ReportEnvironment reportEnvironment) {
        if (reportEnvironment == null) {
            throw new NullPointerException();
        }
        this.reportEnvironment = reportEnvironment;
        this.notifyNodePropertiesChanged();
    }

    public String getTitle() {
        Object o;
        DocumentBundle bundle = this.getBundle();
        if (bundle != null && (o = bundle.getMetaData().getBundleAttribute("http://purl.org/dc/elements/1.1/", "title")) != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    public PageDefinition getPageDefinition() {
        PageDefinition pageDefinition = (PageDefinition)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "page-definition");
        if (pageDefinition == null) {
            return this.createDefaultPageDefinition();
        }
        return pageDefinition;
    }

    public void setPageDefinition(PageDefinition format) {
        if (format == null) {
            format = this.createDefaultPageDefinition();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "page-definition", format);
        this.notifyNodePropertiesChanged();
    }

    private PageDefinition createDefaultPageDefinition() {
        ExtendedConfiguration config = ClassicEngineBoot.getInstance().getExtendedConfig();
        SimplePageDefinition format = config.getBoolProperty("org.pentaho.reporting.engine.classic.core.NoPrinterAvailable") ? new SimplePageDefinition(new PageFormat()) : new SimplePageDefinition(PrinterJob.getPrinterJob().defaultPage());
        return format;
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public void setDataFactory(DataFactory dataFactory) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        DataFactory old = this.dataFactory;
        this.dataFactory = dataFactory;
        this.notifyNodeChildRemoved(old);
        this.notifyNodeChildAdded(dataFactory);
    }

    @Override
    public MasterReport clone() {
        MasterReport report = (MasterReport)super.clone();
        report.reportConfiguration = (HierarchicalConfiguration)this.reportConfiguration.clone();
        report.reportEnvironment = (ReportEnvironment)this.reportEnvironment.clone();
        if (report.reportEnvironment instanceof DefaultReportEnvironment) {
            DefaultReportEnvironment dre = (DefaultReportEnvironment)report.reportEnvironment;
            dre.update((Configuration)report.reportConfiguration);
        }
        report.parameterDefinition = (ReportParameterDefinition)this.parameterDefinition.clone();
        report.parameterValues = (ReportParameterValues)this.parameterValues.clone();
        report.dataFactory = this.dataFactory.derive();
        report.addReportModelListener(new DocumentBundleChangeHandler());
        report.addReportModelListener(new ResourceBundleChangeHandler());
        return report;
    }

    @Override
    public MasterReport derive(boolean preserveElementInstanceIds) {
        MasterReport report = (MasterReport)super.derive(preserveElementInstanceIds);
        report.reportConfiguration = (HierarchicalConfiguration)this.reportConfiguration.clone();
        report.reportEnvironment = (ReportEnvironment)this.reportEnvironment.clone();
        if (report.reportEnvironment instanceof DefaultReportEnvironment) {
            DefaultReportEnvironment dre = (DefaultReportEnvironment)report.reportEnvironment;
            dre.update((Configuration)report.reportConfiguration);
        }
        report.parameterDefinition = (ReportParameterDefinition)this.parameterDefinition.clone();
        report.parameterValues = (ReportParameterValues)this.parameterValues.clone();
        report.dataFactory = this.dataFactory.derive();
        report.addReportModelListener(new DocumentBundleChangeHandler());
        report.addReportModelListener(new ResourceBundleChangeHandler());
        return report;
    }

    public ModifiableConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Configuration getConfiguration() {
        return this.reportConfiguration;
    }

    @Override
    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.updateResourceBundleFactoryInternal();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.notifyNodePropertiesChanged(resourceManager);
    }

    public ReportParameterValues getParameterValues() {
        return this.parameterValues;
    }

    @Override
    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        this.fireModelLayoutChanged(element, type, parameter);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        try {
            DocumentBundle bundle = this.getBundle();
            stream.writeObject(bundle.getMetaData().getBundleType());
            MemoryDocumentBundle mem = new MemoryDocumentBundle();
            BundleUtilities.copyStickyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle);
            BundleUtilities.copyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle, (String[])LegacyBundleResourceRegistry.getInstance().getRegisteredFiles(), (boolean)true);
            BundleUtilities.copyMetaData((MemoryDocumentBundle)mem, (DocumentBundle)bundle);
            mem.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.serialized-bundle");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BundleUtilities.writeAsZip((OutputStream)outputStream, (DocumentBundle)mem);
            stream.writeObject(outputStream.toByteArray());
        }
        catch (ContentIOException e) {
            throw new IOException("Unable to serialize the bundle", e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.updateResourceBundleFactoryInternal();
        this.reportConfiguration.reconnectConfiguration(ClassicEngineBoot.getInstance().getGlobalConfig());
        this.addReportModelListener(new DocumentBundleChangeHandler());
        try {
            String bundleType = (String)stream.readObject();
            byte[] bundleRawZip = (byte[])stream.readObject();
            ResourceManager mgr = this.getResourceManager();
            Resource bundleResource = mgr.createDirectly((Object)bundleRawZip, DocumentBundle.class);
            DocumentBundle bundle = (DocumentBundle)bundleResource.getResource();
            MemoryDocumentBundle mem = new MemoryDocumentBundle(this.getContentBase());
            BundleUtilities.copyStickyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle);
            BundleUtilities.copyInto((WriteableDocumentBundle)mem, (DocumentBundle)bundle, (String[])LegacyBundleResourceRegistry.getInstance().getRegisteredFiles(), (boolean)true);
            BundleUtilities.copyMetaData((MemoryDocumentBundle)mem, (DocumentBundle)bundle);
            mem.getWriteableDocumentMetaData().setBundleType(bundleType);
            this.setBundle((DocumentBundle)mem);
        }
        catch (ResourceException e) {
            throw new IOException(e);
        }
    }

    private void updateResourceBundleFactoryInternal() {
        if (this.resourceBundleFactory instanceof ExtendedResourceBundleFactory) {
            ExtendedResourceBundleFactory erbf = (ExtendedResourceBundleFactory)this.resourceBundleFactory;
            erbf.setResourceLoader(this.getResourceManager(), this.getContentBase());
        }
    }

    public Integer getCompatibilityLevel() {
        Object definedCompatLevel = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "compatibility-level");
        if (definedCompatLevel instanceof Integer) {
            return (Integer)definedCompatLevel;
        }
        return null;
    }

    public void setCompatibilityLevel(Integer level) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "compatibility-level", level);
    }

    public void updateLegacyConfiguration() {
    }

    public ElementStyleDefinition getStyleDefinition() {
        return (ElementStyleDefinition)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet");
    }

    public void setStyleDefinition(ElementStyleDefinition styleDefinition) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet", styleDefinition);
    }

    public ResourceKey getStyleSheetReference() {
        return (ResourceKey)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet-reference");
    }

    public void setStyleSheetReference(ResourceKey styleSheetReference) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-sheet-reference", styleSheetReference);
    }

    public String getContentCacheKey() {
        return (String)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "content-cache-key");
    }

    public void setContentCacheKey(String contentCacheKey) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "content-cache-key", contentCacheKey);
    }

    public boolean isStrictLegacyMode() {
        return "true".equals(this.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.StrictCompatibility"));
    }

    public void setStrictLegacyMode(boolean strict) {
        this.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.StrictCompatibility", String.valueOf(strict));
    }

    @Override
    public ReportDefinition getMasterReport() {
        return this;
    }

    private static class DocumentBundleChangeHandler
    implements ReportModelListener {
        private static final Log log = LogFactory.getLog(DocumentBundleChangeHandler.class);

        private DocumentBundleChangeHandler() {
        }

        @Override
        public void nodeChanged(ReportModelEvent event) {
            if (!(event.getElement() instanceof MasterReport)) {
                return;
            }
            MasterReport report = (MasterReport)event.getElement();
            if (event.getParameter() instanceof AttributeChange) {
                AttributeChange attributeChange = (AttributeChange)event.getParameter();
                if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(attributeChange.getNamespace()) && "bundle".equals(attributeChange.getName())) {
                    Object value = attributeChange.getNewValue();
                    if (!(value instanceof DocumentBundle)) {
                        return;
                    }
                    log.debug((Object)"DocumentBundle change detected - changing the ResourceManager for the MasterReport");
                    DocumentBundle newDocumentBundle = (DocumentBundle)value;
                    ResourceManager resourceManager = newDocumentBundle.getResourceManager();
                    report.setContentBase(newDocumentBundle.getBundleKey());
                    report.setResourceManager(resourceManager);
                }
            } else if (event.getParameter() instanceof ResourceManager) {
                ResourceManager mgr = report.getResourceManager();
                ResourceBundleFactory resourceBundleFactory = report.getResourceBundleFactory();
                if (resourceBundleFactory instanceof LibLoaderResourceBundleFactory) {
                    LibLoaderResourceBundleFactory ll = (LibLoaderResourceBundleFactory)resourceBundleFactory;
                    ll.setResourceLoader(mgr, report.getContentBase());
                }
            }
        }
    }

    private static class ResourceBundleChangeHandler
    implements ReportModelListener {
        private ResourceBundleChangeHandler() {
        }

        @Override
        public void nodeChanged(ReportModelEvent event) {
            if (event.isNodeStructureChanged()) {
                return;
            }
            if (event.getParameter() instanceof StyleChange) {
                return;
            }
            Object element = event.getElement();
            if (!(element instanceof MasterReport)) {
                return;
            }
            MasterReport report = (MasterReport)element;
            report.updateResourceBundleFactoryInternal();
        }
    }
}

