/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.PageFooterType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.RootLevelBandDefaultStyleSheet;

public class PageFooter
extends Band
implements RootLevelBand {
    private static final SubReport[] EMPTY_REPORTS = new SubReport[0];

    public PageFooter() {
        this.setElementType(new PageFooterType());
    }

    public PageFooter(boolean onFirstPage, boolean onLastPage) {
        this.setDisplayOnFirstPage(onFirstPage);
        this.setDisplayOnLastPage(onLastPage);
    }

    public boolean isDisplayOnFirstPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, false);
    }

    public void setDisplayOnFirstPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    public boolean isDisplayOnLastPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, false);
    }

    public void setDisplayOnLastPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    @Override
    public final int getSubReportCount() {
        return 0;
    }

    @Override
    public final SubReport getSubReport(int index) {
        throw new IndexOutOfBoundsException("PageFooter cannot have subreports.");
    }

    public boolean isSticky() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.STICKY, false);
    }

    public void setSticky(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.STICKY, b);
        this.notifyNodePropertiesChanged();
    }

    @Override
    public SubReport[] getSubReports() {
        return EMPTY_REPORTS;
    }

    @Override
    public ElementStyleSheet getDefaultStyleSheet() {
        return RootLevelBandDefaultStyleSheet.getRootLevelBandDefaultStyle();
    }
}

