/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.script.ScriptEngineFactory;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelEvent;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelListenerAdapter;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.GlobalTemplateAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.Messages;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryAddAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryLanguageListCellRenderer;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryListCellRenderer;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryRemoveAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.QueryTemplateAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.TextFieldBinding;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;

public abstract class QueryEditorPanel<T>
extends JPanel {
    private QueryDialogModel<T> dialogModel;
    private JList queryNameList;
    private JTextField queryNameTextField;
    private SmartComboBox globalLanguageField;
    private RSyntaxTextArea globalScriptTextArea;
    private RSyntaxTextArea queryScriptTextArea;
    private SmartComboBox queryLanguageField;
    private QueryLanguageListCellRenderer queryLanguageListCellRenderer;
    private GlobalTemplateAction globalTemplateAction;
    private QueryTemplateAction queryTemplateAction;

    protected QueryEditorPanel(QueryDialogModel<T> dialogModel) {
        if (dialogModel == null) {
            throw new NullPointerException();
        }
        this.dialogModel = dialogModel;
        this.init();
    }

    private void init() {
        this.globalTemplateAction = new GlobalTemplateAction<T>(this, this.dialogModel);
        this.queryTemplateAction = new QueryTemplateAction<T>(this, this.dialogModel);
        this.queryNameList = new JList<T>(this.dialogModel.getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.setCellRenderer(new QueryListCellRenderer());
        this.queryNameList.addListSelectionListener(new QuerySelectedHandler(this.dialogModel, this.queryNameList));
        this.queryNameTextField = new JTextField();
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.setEnabled(this.dialogModel.isQuerySelected());
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)new QueryNameUpdateHandler()));
        this.globalScriptTextArea = new RSyntaxTextArea();
        this.globalScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.globalScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new GlobalScriptUpdateHandler()));
        this.globalLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.globalLanguageField.setRenderer((ListCellRenderer)new QueryLanguageListCellRenderer());
        this.globalLanguageField.addActionListener((ActionListener)new UpdateGlobalScriptLanguageHandler());
        this.queryScriptTextArea = new RSyntaxTextArea();
        this.queryScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.queryScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryScriptUpdateHandler()));
        this.queryLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.queryLanguageListCellRenderer = new QueryLanguageListCellRenderer();
        this.queryLanguageField.setRenderer((ListCellRenderer)this.queryLanguageListCellRenderer);
        this.queryLanguageField.addActionListener((ActionListener)new UpdateQueryScriptLanguageHandler());
        this.dialogModel.addQueryDialogModelListener(new DialogModelChangesDispatcher());
        this.initialize();
        this.createComponents();
    }

    protected abstract void initialize();

    public QueryDialogModel<T> getDialogModel() {
        return this.dialogModel;
    }

    private String getSelectedGlobalScriptLanguage() {
        Object selectedItem = this.globalLanguageField.getSelectedItem();
        if (!(selectedItem instanceof ScriptEngineFactory)) {
            return null;
        }
        ScriptEngineFactory engineFactory = (ScriptEngineFactory)selectedItem;
        return engineFactory.getLanguageName();
    }

    private String getSelectedQueryScriptLanguage() {
        Object selectedItem = this.queryLanguageField.getSelectedItem();
        if (!(selectedItem instanceof ScriptEngineFactory)) {
            return null;
        }
        ScriptEngineFactory engineFactory = (ScriptEngineFactory)selectedItem;
        return engineFactory.getLanguageName();
    }

    private void setQueryScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.queryLanguageField);
    }

    private void setGlobalScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.globalLanguageField);
    }

    protected void setScriptingLanguage(String lang, JComboBox languageField) {
        if (lang == null) {
            languageField.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = languageField.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptEngineFactory elementAt = (ScriptEngineFactory)model.getElementAt(i);
            if (elementAt == null || !elementAt.getNames().contains(lang)) continue;
            languageField.setSelectedItem(elementAt);
            return;
        }
    }

    private JPanel createQueryScriptTab() {
        JPanel queryHeader2 = new JPanel(new BorderLayout());
        queryHeader2.add((Component)new JLabel(Messages.getString("QueryEditorPanel.QueryScript", new Object[0])), "Center");
        queryHeader2.add((Component)new JButton(this.queryTemplateAction), "East");
        JPanel queryScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        queryScriptHeader.add(new JLabel(Messages.getString("QueryEditorPanel.QueryScriptLanguage", new Object[0])));
        queryScriptHeader.add((Component)this.queryLanguageField);
        queryScriptHeader.add(queryHeader2);
        JPanel queryScriptContentHolder = new JPanel(new BorderLayout());
        queryScriptContentHolder.add((Component)queryScriptHeader, "North");
        queryScriptContentHolder.add((Component)new RTextScrollPane(700, 300, (RTextArea)this.queryScriptTextArea, true), "Center");
        return queryScriptContentHolder;
    }

    private JPanel createGlobalScriptTab() {
        JPanel globalHeader2 = new JPanel(new BorderLayout());
        globalHeader2.add((Component)new JLabel(Messages.getString("QueryEditorPanel.GlobalScript", new Object[0])), "Center");
        globalHeader2.add((Component)new JButton(this.globalTemplateAction), "East");
        JPanel globalScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        globalScriptHeader.add(new JLabel(Messages.getString("QueryEditorPanel.GlobalScriptLanguage", new Object[0])));
        globalScriptHeader.add((Component)this.globalLanguageField);
        globalScriptHeader.add(globalHeader2);
        JPanel globalScriptContentHolder = new JPanel(new BorderLayout());
        globalScriptContentHolder.add((Component)globalScriptHeader, "North");
        globalScriptContentHolder.add((Component)new RTextScrollPane(700, 600, (RTextArea)this.globalScriptTextArea, true), "Center");
        globalScriptContentHolder.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return globalScriptContentHolder;
    }

    protected void createComponents() {
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", this.createQueryDetailsPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("QueryEditorPanel.DataSource", new Object[0]), queryContentPanel);
        tabbedPane.addTab(Messages.getString("QueryEditorPanel.GlobalScripting", new Object[0]), this.createGlobalScriptTab());
        this.setLayout(new BorderLayout());
        this.add("Center", tabbedPane);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
    }

    protected JComponent getExtraQueryButtons() {
        return null;
    }

    protected abstract JComponent getQueryEditor();

    private JPanel createQueryDetailsPanel() {
        JPanel queryNamePanel = new JPanel(new BorderLayout());
        queryNamePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        queryNamePanel.add((Component)new JLabel(Messages.getString("QueryEditorPanel.QueryStringLabel", new Object[0])), "North");
        queryNamePanel.add((Component)this.queryNameTextField, "South");
        JPanel queryControlsPanel = new JPanel(new BorderLayout());
        queryControlsPanel.add((Component)new JLabel(Messages.getString("QueryEditorPanel.QueryDetailsLabel", new Object[0])), "West");
        JComponent extraQueryButtons = this.getExtraQueryButtons();
        if (extraQueryButtons != null) {
            queryControlsPanel.add((Component)extraQueryButtons, "East");
        }
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.add((Component)queryControlsPanel, "North");
        queryPanel.add((Component)this.getQueryEditor(), "Center");
        queryPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        JTabbedPane queryScriptTabPane = new JTabbedPane();
        queryScriptTabPane.addTab(Messages.getString("QueryEditorPanel.StaticQuery", new Object[0]), queryPanel);
        queryScriptTabPane.addTab(Messages.getString("QueryEditorPanel.QueryScripting", new Object[0]), this.createQueryScriptTab());
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.add("North", queryNamePanel);
        queryDetailsPanel.add("Center", queryScriptTabPane);
        return queryDetailsPanel;
    }

    private JPanel createQueryListPanel() {
        JPanel queryButtons = new JPanel(new FlowLayout(2, 5, 5));
        queryButtons.add((Component)new BorderlessButton(new QueryAddAction<T>(this.dialogModel)));
        queryButtons.add((Component)new BorderlessButton(new QueryRemoveAction<T>(this.dialogModel)));
        JPanel queryControlPanel = new JPanel(new BorderLayout());
        queryControlPanel.add((Component)new JLabel(Messages.getString("QueryEditorPanel.AvailableQueries", new Object[0])), "West");
        queryControlPanel.add((Component)queryButtons, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", queryControlPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    protected void updateSelectedQueryFromModel() {
    }

    private class DialogModelChangesDispatcher<T>
    extends QueryDialogModelListenerAdapter<T> {
        private DialogModelChangesDispatcher() {
        }

        @Override
        public void globalScriptChanged(QueryDialogModelEvent<T> event) {
            String globalScript = QueryEditorPanel.this.dialogModel.getGlobalScript();
            String globalScriptLanguage = QueryEditorPanel.this.dialogModel.getGlobalScriptLanguage();
            if (!ObjectUtilities.equal((Object)QueryEditorPanel.this.getSelectedGlobalScriptLanguage(), (Object)globalScriptLanguage)) {
                QueryEditorPanel.this.setGlobalScriptingLanguage(globalScriptLanguage);
                ScriptEngineFactory globalLanguage = (ScriptEngineFactory)QueryEditorPanel.this.globalLanguageField.getSelectedItem();
                QueryEditorPanel.this.globalScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting(globalLanguage));
                QueryEditorPanel.this.queryLanguageListCellRenderer.setDefaultValue(globalLanguage);
            }
            if (!ObjectUtilities.equal((Object)QueryEditorPanel.this.globalScriptTextArea.getText(), (Object)globalScript)) {
                QueryEditorPanel.this.globalScriptTextArea.setText(globalScript);
            }
            QueryEditorPanel.this.globalTemplateAction.update((ScriptEngineFactory)QueryEditorPanel.this.globalLanguageField.getSelectedItem());
        }

        @Override
        public void queryUpdated(QueryDialogModelEvent<T> event) {
            if (ObjectUtilities.equal(event.getNewQuery(), QueryEditorPanel.this.dialogModel.getSelectedQuery())) {
                this.selectionChanged(event);
            }
        }

        @Override
        public void selectionChanged(QueryDialogModelEvent<T> event) {
            Query<T> newQuery = event.getNewQuery();
            if (newQuery == null) {
                QueryEditorPanel.this.queryScriptTextArea.setEnabled(false);
                QueryEditorPanel.this.queryScriptTextArea.setText(null);
                QueryEditorPanel.this.queryLanguageField.setEnabled(false);
                QueryEditorPanel.this.setQueryScriptingLanguage(null);
                QueryEditorPanel.this.queryNameTextField.setEnabled(false);
                QueryEditorPanel.this.queryNameTextField.setText(null);
                QueryEditorPanel.this.queryNameList.setSelectedIndex(-1);
            } else {
                QueryEditorPanel.this.queryScriptTextArea.setEnabled(true);
                QueryEditorPanel.this.queryScriptTextArea.setText(newQuery.getQueryScript());
                QueryEditorPanel.this.queryLanguageField.setEnabled(true);
                QueryEditorPanel.this.setQueryScriptingLanguage(newQuery.getQueryLanguage());
                QueryEditorPanel.this.queryNameTextField.setEnabled(true);
                QueryEditorPanel.this.queryNameTextField.setText(newQuery.getName());
                QueryEditorPanel.this.queryNameList.setSelectedIndex(event.getNewIndex());
                ScriptEngineFactory queryScriptLanguage = (ScriptEngineFactory)QueryEditorPanel.this.queryLanguageField.getSelectedItem();
                if (queryScriptLanguage == null) {
                    QueryEditorPanel.this.queryScriptTextArea.setSyntaxEditingStyle(QueryEditorPanel.this.globalScriptTextArea.getSyntaxEditingStyle());
                } else {
                    QueryEditorPanel.this.queryScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting(queryScriptLanguage));
                }
            }
            QueryEditorPanel.this.queryTemplateAction.update((ScriptEngineFactory)QueryEditorPanel.this.queryLanguageField.getSelectedItem());
            QueryEditorPanel.this.updateSelectedQueryFromModel();
        }
    }

    private class QueryScriptUpdateHandler
    extends TextFieldBinding {
        private QueryScriptUpdateHandler() {
        }

        @Override
        protected void performUpdate() {
            Query selectedQuery = QueryEditorPanel.this.dialogModel.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            String text = QueryEditorPanel.this.queryScriptTextArea.getText();
            if (StringUtils.isEmpty((String)text)) {
                text = null;
            }
            if (ObjectUtilities.equal((Object)text, (Object)selectedQuery.getQueryScript())) {
                return;
            }
            QueryEditorPanel.this.dialogModel.updateSelectedQuery(selectedQuery.updateQueryScript(QueryEditorPanel.this.getSelectedQueryScriptLanguage(), text));
        }
    }

    private class GlobalScriptUpdateHandler
    extends TextFieldBinding {
        private GlobalScriptUpdateHandler() {
        }

        @Override
        protected void performUpdate() {
            String text = QueryEditorPanel.this.globalScriptTextArea.getText();
            if (StringUtils.isEmpty((String)text)) {
                text = null;
            }
            if (ObjectUtilities.equal((Object)text, (Object)QueryEditorPanel.this.dialogModel.getGlobalScript())) {
                return;
            }
            QueryEditorPanel.this.dialogModel.setGlobalScripting(QueryEditorPanel.this.getSelectedGlobalScriptLanguage(), text);
        }
    }

    private class QueryNameUpdateHandler
    extends TextFieldBinding {
        private QueryNameUpdateHandler() {
        }

        @Override
        protected void performUpdate() {
            Query selectedQuery = QueryEditorPanel.this.dialogModel.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            String text = QueryEditorPanel.this.queryNameTextField.getText();
            if (ObjectUtilities.equal((Object)text, (Object)selectedQuery.getName())) {
                return;
            }
            QueryEditorPanel.this.dialogModel.updateSelectedQuery(selectedQuery.updateName(text));
        }
    }

    private class UpdateGlobalScriptLanguageHandler
    implements ActionListener {
        private UpdateGlobalScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryEditorPanel.this.dialogModel.setGlobalScripting(QueryEditorPanel.this.getSelectedGlobalScriptLanguage(), QueryEditorPanel.this.dialogModel.getGlobalScript());
        }
    }

    private class UpdateQueryScriptLanguageHandler
    implements ActionListener {
        private UpdateQueryScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Query query = QueryEditorPanel.this.dialogModel.getSelectedQuery();
            if (query == null) {
                return;
            }
            String selectedQueryScriptLanguage = QueryEditorPanel.this.getSelectedQueryScriptLanguage();
            if (ObjectUtilities.equal((Object)selectedQueryScriptLanguage, (Object)query.getQueryLanguage())) {
                return;
            }
            Query newQuery = query.updateQueryScript(selectedQueryScriptLanguage, query.getQueryScript());
            QueryEditorPanel.this.dialogModel.updateSelectedQuery(newQuery);
        }
    }

    private class QuerySelectedHandler
    implements ListSelectionListener {
        private QueryDialogModel<T> dialogModel;
        private JList queryNameList;

        private QuerySelectedHandler(QueryDialogModel<T> dialogModel, JList queryNameList) {
            this.dialogModel = dialogModel;
            this.queryNameList = queryNameList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.dialogModel.setSelectedQuery((Query)this.queryNameList.getSelectedValue());
        }
    }
}

