/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.filter.types.RotatableText;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ResourceFieldType
extends AbstractElementType
implements RotatableText {
    public static final ResourceFieldType INSTANCE = new ResourceFieldType();
    private static final Log logger = LogFactory.getLog(ResourceFieldType.class);

    public ResourceFieldType() {
        super("resource-field");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object resourceKeyRaw = ElementTypeUtils.queryFieldName(element);
        if (resourceKeyRaw == null) {
            return this.rotate(element, "<null>", runtime);
        }
        return this.rotate(element, resourceKeyRaw.toString(), runtime);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object resourceKeyRaw = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (resourceKeyRaw == null) {
            return this.rotate(element, element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value"), runtime);
        }
        String resourceKey = String.valueOf(resourceKeyRaw);
        String resourceId = ElementTypeUtils.queryResourceId(runtime, element);
        if (resourceId == null) {
            return this.rotate(element, element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value"), runtime);
        }
        try {
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (bundle != null) {
                return this.rotate(element, bundle.getString(resourceKey), runtime);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to retrieve a value for key " + resourceId));
        }
        return this.rotate(element, element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value"), runtime);
    }
}

