/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ConvertToDateExpression
extends AbstractExpression {
    private String field;
    private String format;
    private Locale locale;
    private TimeZone timeZone;
    private transient DateFormat dateFormat;
    private transient Locale lastLocale;
    private transient TimeZone lastTimeZone;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.lastLocale = null;
        this.dateFormat = null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.lastLocale = null;
        this.dateFormat = null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.lastTimeZone = null;
    }

    @Override
    public Object getValue() {
        DataRow dataRow = this.getDataRow();
        Object o = dataRow.get(this.field);
        if (o instanceof Date) {
            return o;
        }
        try {
            DateFormat format;
            Locale localeUsed = this.locale;
            if (localeUsed == null) {
                localeUsed = this.getResourceBundleFactory().getLocale();
            }
            if (this.dateFormat == null || !ObjectUtilities.equal((Object)localeUsed, (Object)this.lastLocale)) {
                String formatString = this.getFormat();
                if (formatString == null || formatString.length() == 0) {
                    this.dateFormat = format = DateFormat.getDateInstance(2, localeUsed);
                    this.lastLocale = localeUsed;
                } else {
                    SimpleDateFormat sformat = new SimpleDateFormat(formatString);
                    if (this.locale != null) {
                        sformat.setDateFormatSymbols(new DateFormatSymbols(this.locale));
                    } else {
                        ResourceBundleFactory factory = this.getResourceBundleFactory();
                        sformat.setDateFormatSymbols(new DateFormatSymbols(factory.getLocale()));
                    }
                    format = sformat;
                    this.dateFormat = sformat;
                    this.lastLocale = localeUsed;
                }
            } else {
                format = this.dateFormat;
            }
            if (!ObjectUtilities.equal((Object)this.timeZone, (Object)this.lastTimeZone)) {
                this.lastTimeZone = this.timeZone;
                format.setTimeZone(this.timeZone);
            }
            return format.parse(String.valueOf(o));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

