/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class DocumentMetaDataFunction
implements Function {
    public String getCanonicalName() {
        return "DOCUMENTMETADATA";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        if (!(context instanceof ReportFormulaContext)) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        ReportFormulaContext rfc = (ReportFormulaContext)context;
        DocumentMetaData data = rfc.getProcessingContext().getDocumentMetaData();
        if (parameterCount == 1) {
            String metaName = context.getTypeRegistry().convertToText(parameters.getType(0), parameters.getValue(0));
            String[] namespaces = data.getMetaDataNamespaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Object attribute = data.getBundleAttribute(namespace, metaName);
                if (attribute == null) continue;
                return new TypeValuePair((Type)AnyType.TYPE, attribute);
            }
        } else {
            String metaNamespace = context.getTypeRegistry().convertToText(parameters.getType(0), parameters.getValue(0));
            String metaName = context.getTypeRegistry().convertToText(parameters.getType(1), parameters.getValue(1));
            Object o = data.getBundleAttribute(metaNamespace, metaName);
            return new TypeValuePair((Type)AnyType.TYPE, o);
        }
        throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_NA_VALUE);
    }
}

