/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.strings;

import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;

public class SubStringExpression
extends AbstractExpression {
    private String field;
    private String ellipsis;
    private int start;
    private int length;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (this.length < 0) {
            throw new IndexOutOfBoundsException("String start position cannot be negative.");
        }
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("String length cannot be negative.");
        }
        this.length = length;
    }

    @Override
    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return null;
        }
        String text = String.valueOf(raw);
        if (this.start >= text.length()) {
            return this.appendEllipsis(null);
        }
        if (this.start + this.length > text.length()) {
            return this.appendEllipsis(text.substring(this.start));
        }
        return text.substring(this.start, this.start + this.length);
    }

    private String appendEllipsis(String value) {
        if (this.ellipsis == null) {
            return value;
        }
        if (value == null) {
            return this.ellipsis;
        }
        return value + this.ellipsis;
    }
}

