/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.text.ParagraphFontMetrics;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpecProducer;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RenderableComplexText
extends RenderNode {
    private RichTextSpec richText;
    private int start;
    private int end;
    private String text;
    private TextLayout textLayout;
    private boolean forceLinebreak;
    private ParagraphFontMetrics paragraphFontMetrics;

    public RenderableComplexText(StyleSheet styleSheet, InstanceID instanceID, ElementType elementType, ReportAttributeMap<Object> attributes, RichTextSpec text) {
        super(new NodeLayoutProperties(styleSheet, attributes, instanceID, elementType));
        this.text = text.getText();
        this.richText = text;
        this.forceLinebreak = false;
        this.start = 0;
        this.end = text.length();
    }

    public RenderableComplexText(StyleSheet styleSheet, InstanceID instanceID, ElementType elementType, ReportAttributeMap<Object> attributes, String text) {
        super(new NodeLayoutProperties(styleSheet, attributes, instanceID, elementType));
        this.text = text;
        this.richText = null;
        this.forceLinebreak = false;
        this.start = 0;
        this.end = text.length();
    }

    public void computeMinimumChunkWidth(OutputProcessorMetaData data, ResourceManager resourceManager) {
        if (this.getMinimumChunkWidth() != 0L) {
            return;
        }
        if (!data.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY) && !this.getStyleSheet().getBooleanStyleProperty(TextStyleKeys.WORDBREAK)) {
            return;
        }
        long minimumChunkWidth = 0L;
        BreakIterator wordInstance = BreakIterator.getWordInstance();
        wordInstance.setText(this.text);
        boolean antiAliasing = RenderUtility.isFontSmooth(this.getStyleSheet(), data);
        FontRenderContext fontRenderContext = new FontRenderContext(null, antiAliasing, true);
        int start = wordInstance.first();
        int end = wordInstance.next();
        while (end != -1) {
            String word = this.text.substring(start, end);
            AttributedCharacterIterator attributedCharacterIterator = new RichTextSpecProducer(data, resourceManager).computeText(this, word).createAttributedCharacterIterator();
            TextLayout t = new TextLayout(attributedCharacterIterator, fontRenderContext);
            double width = t.getVisibleAdvance();
            long wordMinChunkWidth = StrictGeomUtility.toInternalValue(width);
            minimumChunkWidth = Math.max(minimumChunkWidth, wordMinChunkWidth);
            start = end;
            end = wordInstance.next();
        }
        this.setMinimumChunkWidth(minimumChunkWidth);
    }

    @Override
    public int getNodeType() {
        return 273;
    }

    public String getRawText() {
        return this.text;
    }

    public RichTextSpec getRichText() {
        if (this.richText == null) {
            throw new IllegalStateException("Calling 'getRichText' is only valid after layouting is complete.");
        }
        return this.richText.substring(this.start, this.end);
    }

    public TextLayout getTextLayout() {
        return this.textLayout;
    }

    public void setTextLayout(TextLayout textLayout) {
        this.textLayout = textLayout;
    }

    public void setForceLinebreak(boolean forceLinebreak) {
        this.forceLinebreak = forceLinebreak;
    }

    public boolean isForceLinebreak() {
        return this.forceLinebreak;
    }

    public RenderableComplexText merge(RenderableComplexText suffix) {
        if (this.richText != suffix.richText) {
            throw new IllegalStateException("Not from the same source");
        }
        RenderableComplexText text = (RenderableComplexText)this.derive(true);
        text.end = suffix.end;
        text.setMinimumChunkWidth(Math.max(this.getMinimumChunkWidth(), suffix.getMinimumChunkWidth()));
        return text;
    }

    public boolean isSameSource(RenderableComplexText suffix) {
        return this.richText == suffix.richText;
    }

    public void setParagraphFontMetrics(ParagraphFontMetrics paragraphFontMetrics) {
        this.paragraphFontMetrics = paragraphFontMetrics;
    }

    public ParagraphFontMetrics getParagraphFontMetrics() {
        return this.paragraphFontMetrics;
    }
}

