/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;

public final class SpacerRenderNode
extends RenderNode {
    private boolean empty;
    private boolean preserve;
    private int spaceCount;

    public SpacerRenderNode() {
        this(0L, 0L, false, 0);
    }

    public SpacerRenderNode(long width, long height, boolean preserve, int spaceCount) {
        super(NodeLayoutProperties.GENERIC_PROPERTIES);
        this.preserve = preserve;
        this.spaceCount = spaceCount;
        this.setMaximumBoxWidth(width);
        this.setMinimumChunkWidth(0L);
        this.empty = width == 0L && height == 0L;
    }

    @Override
    public int getNodeType() {
        return 65;
    }

    public int getSpaceCount() {
        return this.spaceCount;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean isDiscardable() {
        return !this.preserve;
    }

    @Override
    public boolean isIgnorableForRendering() {
        return true;
    }
}

