/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.context;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;

public final class StaticBoxLayoutProperties
implements Serializable {
    private static final int FLAG_AVOID_PAGEBREAK = 1;
    private static final int FLAG_PRESERVE_SPACE = 2;
    private static final int FLAG_OVERFLOW_X = 4;
    private static final int FLAG_OVERFLOW_Y = 8;
    private static final int FLAG_INVISIBLE_CONSUMES_SPACE = 16;
    private static final int FLAG_VISIBLE = 32;
    private static final int FLAG_BREAK_AFTER = 64;
    private static final int FLAG_SECTION_CONTEXT = 128;
    private static final int FLAG_WIDOW_ORPHAN_OPT_OUT = 256;
    private static final int FLAG_DEFINED_WIDTH = 512;
    private static final Log logger = LogFactory.getLog(StaticBoxLayoutProperties.class);
    private long borderLeft;
    private long borderRight;
    private long borderTop;
    private long borderBottom;
    private int dominantBaseline;
    private ExtendedBaselineInfo nominalBaselineInfo;
    private int widows;
    private int orphans;
    private int flags;
    private String fontFamily;
    private long spaceWidth;
    private PlaceholderType placeholderBox = PlaceholderType.NONE;

    private void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    private boolean isFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isWidowOrphanOptOut() {
        return this.isFlag(256);
    }

    public void setWidowOrphanOptOut(boolean widowOrphanOptOut) {
        this.setFlag(256, widowOrphanOptOut);
    }

    public boolean isDefinedWidth() {
        return this.isFlag(512);
    }

    public void setDefinedWidth(boolean definedWidth) {
        this.setFlag(512, definedWidth);
    }

    public boolean isSectionContext() {
        return this.isFlag(128);
    }

    public void setSectionContext(boolean sectionContext) {
        this.setFlag(128, sectionContext);
    }

    public long getSpaceWidth() {
        return this.spaceWidth;
    }

    public void setSpaceWidth(long spaceWidth) {
        this.spaceWidth = spaceWidth;
    }

    public long getMarginLeft() {
        return 0L;
    }

    public long getMarginRight() {
        return 0L;
    }

    public long getMarginTop() {
        return 0L;
    }

    public long getMarginBottom() {
        return 0L;
    }

    public long getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(long borderLeft) {
        this.borderLeft = borderLeft;
    }

    public long getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(long borderRight) {
        this.borderRight = borderRight;
    }

    public long getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(long borderTop) {
        this.borderTop = borderTop;
    }

    public long getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(long borderBottom) {
        this.borderBottom = borderBottom;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public void setDominantBaseline(int dominantBaseline) {
        this.dominantBaseline = dominantBaseline;
    }

    public ExtendedBaselineInfo getNominalBaselineInfo() {
        return this.nominalBaselineInfo;
    }

    public boolean isBaselineCalculated() {
        return this.nominalBaselineInfo != null;
    }

    public void setNominalBaselineInfo(ExtendedBaselineInfo nominalBaselineInfo) {
        if (nominalBaselineInfo == null) {
            throw new NullPointerException();
        }
        this.nominalBaselineInfo = nominalBaselineInfo;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getWidows() {
        return this.widows;
    }

    public void setWidows(int widows) {
        this.widows = widows;
    }

    public int getOrphans() {
        return this.orphans;
    }

    public void setOrphans(int orphans) {
        this.orphans = orphans;
    }

    public boolean isAvoidPagebreakInside() {
        return this.isFlag(1);
    }

    public void setAvoidPagebreakInside(boolean avoidPagebreakInside) {
        this.setFlag(1, avoidPagebreakInside);
    }

    public boolean isPreserveSpace() {
        return this.isFlag(2);
    }

    public void setPreserveSpace(boolean preserveSpace) {
        this.setFlag(2, preserveSpace);
    }

    public boolean isBreakAfter() {
        return this.isFlag(64);
    }

    public void setBreakAfter(boolean breakAfter) {
        this.setFlag(64, breakAfter);
    }

    public boolean isOverflowX() {
        return this.isFlag(4);
    }

    public void setOverflowX(boolean overflowX) {
        this.setFlag(4, overflowX);
    }

    public boolean isOverflowY() {
        return this.isFlag(8);
    }

    public void setOverflowY(boolean overflowY) {
        this.setFlag(8, overflowY);
    }

    public boolean isInvisibleConsumesSpace() {
        return this.isFlag(16);
    }

    public void setInvisibleConsumesSpace(boolean invisibleConsumesSpace) {
        this.setFlag(16, invisibleConsumesSpace);
    }

    public boolean isVisible() {
        return this.isFlag(32);
    }

    public void setVisible(boolean visible) {
        this.setFlag(32, visible);
    }

    public boolean isPlaceholderBox() {
        return this.placeholderBox != PlaceholderType.NONE;
    }

    public PlaceholderType getPlaceholderBox() {
        return this.placeholderBox;
    }

    public void setPlaceholderBox(PlaceholderType placeholderBox) {
        if (placeholderBox == null) {
            throw new NullPointerException();
        }
        this.placeholderBox = placeholderBox;
    }

    public String toString() {
        return "StaticBoxLayoutProperties{borderLeft=" + this.borderLeft + ", borderRight=" + this.borderRight + ", borderTop=" + this.borderTop + ", borderBottom=" + this.borderBottom + ", dominantBaseline=" + this.dominantBaseline + ", widows=" + this.widows + ", orphans=" + this.orphans + ", avoidPagebreakInside=" + this.isAvoidPagebreakInside() + ", preserveSpace=" + this.isPreserveSpace() + ", visible=" + this.isVisible() + ", placeholderBox=" + (Object)((Object)this.placeholderBox) + ", invisibleConsumesSpace=" + this.isInvisibleConsumesSpace() + '}';
    }

    public static enum PlaceholderType {
        NONE,
        SECTION,
        COMPLEX;

    }
}

