/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.PageState;
import org.pentaho.reporting.engine.classic.core.layout.output.PageStateList;
import org.pentaho.reporting.engine.classic.core.layout.output.ReportProcessor;

public class FastPageStateList
implements PageStateList {
    private int size;
    private PageState initialState;
    private ReportProcessor reportProcessor;

    public FastPageStateList(ReportProcessor reportProcessor) {
        if (reportProcessor == null) {
            throw new NullPointerException();
        }
        this.reportProcessor = reportProcessor;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(PageState state) {
        if (this.size == 0) {
            state.prepareStorage();
            this.initialState = state;
        }
        ++this.size;
    }

    @Override
    public void clear() {
        this.initialState = null;
        this.size = 0;
    }

    @Override
    public PageState get(int index) {
        if (index == 0) {
            return this.initialState;
        }
        try {
            PageState state = this.initialState;
            for (int i = 0; i <= index; ++i) {
                if ((state = this.reportProcessor.processPage(state, false)) != null) continue;
                throw new IllegalStateException("State returned is null: Report processing reached premature end-point.");
            }
            return state;
        }
        catch (ReportProcessingException e) {
            throw new IllegalStateException("State restoration failed.");
        }
    }
}

