/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BoxShifter;

public final class FillPhysicalPagesStep
extends IterateVisualProcessStep {
    private PageContext pageContext;
    private boolean secondPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalPageBox compute(LogicalPageBox pagebox, long pageStart, long pageEnd) {
        this.getEventWatch().start();
        this.getSummaryWatch().start();
        try {
            long contentStart = pagebox.getHeaderArea().getHeight();
            long contentEnd = pageEnd - pageStart + contentStart;
            this.pageContext = new PageContext(contentStart, contentEnd);
            this.secondPage = pagebox.getPageOffset() != 0L;
            LogicalPageBox derived = pagebox.derive(true);
            BoxShifter.shiftBoxUnchecked(derived, -pageStart + contentStart);
            this.processBoxChilds(derived);
            BlockRenderBox footerArea = derived.getFooterArea();
            BlockRenderBox repeatFooterArea = derived.getRepeatFooterArea();
            long repeatFooterPosition = pagebox.getPageHeight() - repeatFooterArea.getHeight() - footerArea.getHeight();
            BoxShifter.shiftBoxUnchecked(repeatFooterArea, repeatFooterPosition);
            long footerPosition = pagebox.getPageHeight() - footerArea.getHeight();
            BoxShifter.shiftBoxUnchecked(footerArea, footerPosition);
            derived.setPageOffset(0L);
            derived.setPageEnd(contentEnd + footerArea.getHeight() + repeatFooterArea.getHeight());
            LogicalPageBox logicalPageBox = derived;
            return logicalPageBox;
        }
        finally {
            this.getEventWatch().stop();
            this.getSummaryWatch().stop(true);
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    private boolean processBox(RenderBox box) {
        this.establishPageContext(box);
        RenderNode node = box.getFirstChild();
        while (node != null) {
            if ((node.getNodeType() & 2) != 2 && node.isIgnorableForRendering()) {
                node = node.getNext();
                continue;
            }
            if (node.isContainsReservedContent()) {
                node = node.getNext();
                continue;
            }
            long y = node.getY();
            long height = node.getOverflowAreaHeight();
            if (node.getNodeType() == 530 || this.pageContext.isFiltered(y, height)) {
                RenderNode next = node.getNext();
                box.remove(node);
                node = next;
                continue;
            }
            node = node.getNext();
        }
        return true;
    }

    private void establishPageContext(RenderBox box) {
        if (box.getNodeType() == 266242) {
            this.pageContext = new PageContext(this.pageContext);
        }
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        if (box.getNodeType() == 270338) {
            TableSectionRenderBox tsr = (TableSectionRenderBox)box;
            if (tsr.getDisplayRole() == TableSectionRenderBox.Role.BODY) {
                return this.processBox(box);
            }
            if (tsr.getDisplayRole() == TableSectionRenderBox.Role.HEADER) {
                this.pageContext.increaseContentStartArea(box.getHeight());
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox box) {
        return false;
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableRowLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        return this.processBox(box);
    }

    protected void finishBox(RenderBox box) {
        if (box.getNodeType() == 266242) {
            this.pageContext = this.pageContext.pop();
        }
    }

    @Override
    protected void finishBlockLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishCanvasLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishInlineLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishRowLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableCellLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableColGroupLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableColLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableRowLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        this.finishBox(box);
    }

    private static class PageContext {
        private PageContext parent;
        private long contentEnd;
        private long contentStart;

        private PageContext(long contentStart, long contentEnd) {
            this.contentStart = contentStart;
            this.contentEnd = contentEnd;
        }

        private PageContext(PageContext parent) {
            this.parent = parent;
            this.contentStart = parent.contentStart;
            this.contentEnd = parent.contentEnd;
        }

        public PageContext pop() {
            return this.parent;
        }

        public long getContentEnd() {
            return this.contentEnd;
        }

        public long getContentStart() {
            return this.contentStart;
        }

        public void increaseContentStartArea(long value) {
            if (value < 0L) {
                throw new NullPointerException();
            }
            this.contentStart += value;
        }

        public boolean isFiltered(long y, long height) {
            if (y == this.contentStart && height == 0L) {
                return false;
            }
            if (y + height <= this.contentStart) {
                return true;
            }
            return y >= this.contentEnd;
        }
    }
}

