/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleReverseStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowContextPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowPassThroughContext;

public class WidowStep
extends IterateSimpleReverseStructureProcessStep {
    private WidowContext context;
    private WidowContextPool contextPool = new WidowContextPool();
    private WidowPassThroughContext rootContext = new WidowPassThroughContext();
    private boolean invalidNodeFound;

    public boolean processWidowAnnotation(LogicalPageBox box) {
        this.invalidNodeFound = false;
        this.context = this.rootContext;
        this.startProcessing(box.getContentArea());
        this.context = null;
        return this.invalidNodeFound;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBox(RenderBox box) {
        box.setWidowBox(false);
        StaticBoxLayoutProperties properties = box.getStaticBoxLayoutProperties();
        if (!properties.isWidowOrphanOptOut()) {
            this.context.startChild(box);
        }
        if (box.getNodeType() == 530) {
            this.context.registerBreakMark(box);
        }
        this.context = this.contextPool.create(box, this.context);
        return true;
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        FinishedRenderNode finNode;
        node.setWidowBox(false);
        if (node instanceof FinishedRenderNode && (finNode = (FinishedRenderNode)node).isOrphanLeaf()) {
            this.context.registerFinishedNode(finNode);
        }
    }

    @Override
    protected void finishBox(RenderBox box) {
        StaticBoxLayoutProperties properties;
        WidowContext oldContext = this.context;
        this.context = oldContext.commit(box);
        this.contextPool.free(oldContext);
        if (box.isInvalidWidowOrphanNode()) {
            this.invalidNodeFound = true;
        }
        if (!(properties = box.getStaticBoxLayoutProperties()).isWidowOrphanOptOut()) {
            this.context.endChild(box);
        }
    }
}

