/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

public class PageableBreakContext {
    private long shift;
    private long initialShift;
    private long appliedShift;
    private long heightExtension;
    private boolean breakSuspended;

    public void updateFromParent(PageableBreakContext parent, boolean useInitialShift) {
        if (useInitialShift) {
            this.shift = parent.appliedShift;
            this.appliedShift = parent.appliedShift;
            this.initialShift = parent.appliedShift;
        } else {
            this.shift = parent.shift;
            this.appliedShift = parent.shift;
            this.initialShift = parent.shift;
        }
        this.heightExtension = 0L;
        this.breakSuspended = parent.breakSuspended;
    }

    public long getShift() {
        return this.shift;
    }

    public void setShift(long shift) {
        if (this.shift > shift) {
            throw new IllegalStateException("Cannot undo previous shifting");
        }
        this.shift = shift;
    }

    public long getAppliedShift() {
        return this.appliedShift;
    }

    public void setAppliedShift(long appliedShift) {
        this.appliedShift = appliedShift;
    }

    public long getInitialShift() {
        return this.initialShift;
    }

    public boolean isBreakSuspended() {
        return this.breakSuspended;
    }

    public void suspendBreaks() {
        this.breakSuspended = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageableBreakContext");
        sb.append("{shift=").append(this.shift);
        sb.append(", initialShift=").append(this.initialShift);
        sb.append(", breakSuspended=").append(this.breakSuspended);
        sb.append('}');
        return sb.toString();
    }

    public long getHeightExtension() {
        return this.heightExtension;
    }

    public void setHeightExtension(long heightExtension) {
        this.heightExtension = heightExtension;
    }

    public void reset() {
        this.breakSuspended = false;
        this.heightExtension = 0L;
        this.shift = 0L;
        this.appliedShift = 0L;
        this.initialShift = 0L;
    }

    public void commitShift() {
        this.shift = this.appliedShift + this.heightExtension;
    }
}

