/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class RowLevelPaginationShiftState
implements PaginationShiftState {
    private PaginationShiftState parent;
    private long shift;
    private long shiftForChilds;
    private long initialShift;
    private StackedObjectPool<RowLevelPaginationShiftState> pool;
    private RenderBox box;

    public void reuse(StackedObjectPool<RowLevelPaginationShiftState> pool, PaginationShiftState parent, RenderBox box) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.pool = pool;
        this.initialShift = this.shift = (this.shiftForChilds = parent.getShiftForNextChild());
        this.box = box;
    }

    @Override
    public void suspendManualBreaks() {
    }

    @Override
    public boolean isManualBreakSuspended() {
        return this.parent.isManualBreakSuspendedForChilds();
    }

    @Override
    public boolean isManualBreakSuspendedForChilds() {
        return true;
    }

    @Override
    public void updateShiftFromChild(long absoluteValue) {
        this.shift = Math.max(this.shift, absoluteValue);
    }

    @Override
    public long getShiftForNextChild() {
        return this.shiftForChilds;
    }

    @Override
    public PaginationShiftState pop(InstanceID id) {
        if (this.box != null && id != this.box.getInstanceId()) {
            throw new IllegalStateException();
        }
        long effectiveShift = this.shift;
        if (this.box != null && this.box.getParent() != null) {
            long shiftRaw = this.shift - this.initialShift;
            effectiveShift = this.box.getParent().extendHeight(this.box, shiftRaw) + this.initialShift;
            if (effectiveShift != this.initialShift) {
                this.box.getParent().markApplyStateDirty();
            }
        }
        this.parent.updateShiftFromChild(effectiveShift);
        if (this.pool != null) {
            this.pool.free(this);
            this.pool = null;
        }
        this.box = null;
        return this.parent;
    }

    @Override
    public void increaseShift(long value) {
        this.shiftForChilds = Math.max(this.shiftForChilds, this.shiftForChilds + value);
        this.shift = Math.max(this.shift, this.shiftForChilds);
    }

    @Override
    public void setShift(long value) {
        this.shiftForChilds = Math.max(this.shiftForChilds, value);
        this.shift = Math.max(this.shift, this.shiftForChilds);
    }
}

