/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.WidowContext;
import org.pentaho.reporting.engine.classic.core.util.RingBuffer;

public class WidowBlockContext
implements WidowContext {
    private static final Log logger = LogFactory.getLog(WidowBlockContext.class);
    private StackedObjectPool<WidowBlockContext> pool;
    private WidowContext parent;
    private RenderBox contextBox;
    private int widows;
    private int widowCount;
    private RingBuffer<RenderNode> widowSize;
    private long widowOverride;
    private long widowOverrideWithKeepTogether;
    private RenderNode currentNode;
    private boolean breakMarkerSeen;

    public void init(StackedObjectPool<WidowBlockContext> pool, WidowContext parent, RenderBox contextBox, int widows) {
        this.breakMarkerSeen = false;
        this.pool = pool;
        this.parent = parent;
        this.contextBox = contextBox;
        this.widows = widows;
        this.widowCount = 0;
        this.widowOverride = contextBox.getCachedY2();
        this.widowOverrideWithKeepTogether = contextBox.getCachedY2();
        if (widows > 0) {
            if (this.widowSize == null) {
                this.widowSize = new RingBuffer(widows);
            } else {
                this.widowSize.resize(widows);
            }
        }
    }

    @Override
    public void startChild(RenderBox box) {
        this.currentNode = box;
        if (this.parent != null) {
            this.parent.startChild(box);
        }
    }

    @Override
    public void endChild(RenderBox box) {
        if (this.currentNode != null) {
            if (this.widowCount < this.widows && this.widows > 0) {
                this.widowSize.add(box);
                box.setRestrictFinishedClearOut(RenderBox.RestrictFinishClearOut.LEAF);
            }
            ++this.widowCount;
            this.currentNode = null;
        }
        if (this.parent != null) {
            this.parent.endChild(box);
        }
    }

    @Override
    public void registerFinishedNode(FinishedRenderNode box) {
        if (this.widowCount < this.widows && this.widows > 0) {
            this.widowSize.add(box);
            box.getParent().setRestrictFinishedClearOut(RenderBox.RestrictFinishClearOut.RESTRICTED);
        }
        this.widowCount += box.getWidowLeafCount();
        this.currentNode = null;
        if (this.parent != null) {
            this.parent.registerFinishedNode(box);
        }
    }

    @Override
    public void registerBreakMark(RenderBox box) {
        this.breakMarkerSeen = true;
        if (this.parent != null) {
            this.parent.registerBreakMark(box);
        }
    }

    private long getWidowValue() {
        if (this.widows == 0) {
            return this.widowOverride;
        }
        RenderNode box = this.widowSize.getLastValue();
        if (box == null) {
            return this.widowOverride;
        }
        long y2 = box.getCachedY2() - box.getCachedHeight();
        return Math.min(this.widowOverride, y2);
    }

    @Override
    public WidowContext commit(RenderBox box) {
        boolean keepTogether = box.getStaticBoxLayoutProperties().isAvoidPagebreakInside();
        long widowValue = this.getWidowValue();
        long constraintSize = keepTogether ? box.getCachedY2() - box.getCachedY() : box.getCachedY2() - widowValue;
        box.setWidowConstraintSizeWithKeepTogether(constraintSize);
        box.setWidowConstraintSize(box.getCachedY2() - widowValue);
        box.setWidowLeafCount(this.widowCount);
        if (!this.breakMarkerSeen && !box.isInvalidWidowOrphanNode()) {
            boolean incomplete;
            boolean bl = incomplete = box.isOpen() || box.getContentRefCount() > 0;
            if (incomplete) {
                if (this.widows > 0 && this.widowCount == 0) {
                    box.setInvalidWidowOrphanNode(true);
                } else {
                    box.setInvalidWidowOrphanNode(false);
                }
            } else {
                box.setInvalidWidowOrphanNode(false);
            }
        }
        if (this.widowSize != null) {
            for (int i = 0; i < this.widowSize.size(); ++i) {
                RenderNode renderNode = this.widowSize.get(i);
                if (renderNode == null || !(renderNode instanceof RenderBox)) continue;
                RenderBox rbox = (RenderBox)renderNode;
                rbox.setWidowBox(true);
            }
        }
        if (this.parent != null) {
            this.parent.subContextCommitted(box);
        }
        return this.parent;
    }

    @Override
    public void subContextCommitted(RenderBox contextBox) {
        long cachedY2 = contextBox.getCachedY2();
        if (cachedY2 > this.getWidowValue() || cachedY2 == this.contextBox.getCachedY2() && cachedY2 == this.getWidowValue()) {
            this.widowOverride = Math.min(this.widowOverride, cachedY2 - contextBox.getWidowConstraintSize());
            this.widowOverrideWithKeepTogether = Math.min(this.widowOverrideWithKeepTogether, cachedY2 - contextBox.getWidowConstraintSizeWithKeepTogether());
        }
        if (this.parent != null) {
            this.parent.subContextCommitted(contextBox);
        }
    }

    @Override
    public void clearForPooledReuse() {
        this.parent = null;
        this.contextBox = null;
        this.pool.free(this);
    }
}

