/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ReportPreProcessorPropertyMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportPreProcessorPropertyReadHandler
extends AbstractMetaDataReadHandler {
    private boolean validatePropertiesOnBoot = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.StrictValidation"));
    private SharedBeanInfo beanInfo;
    private String bundleLocation;
    private ReportPreProcessorPropertyMetaDataBuilder builder;

    public ReportPreProcessorPropertyReadHandler(SharedBeanInfo beanInfo, String bundleLocation) {
        this.beanInfo = beanInfo;
        this.bundleLocation = bundleLocation;
        this.builder = new ReportPreProcessorPropertyMetaDataBuilder();
    }

    public ReportPreProcessorPropertyMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().mandatory("true".equals(attrs.getValue(this.getUri(), "mandatory")));
        this.getBuilder().computed("true".equals(attrs.getValue(this.getUri(), "computed")));
        this.getBuilder().valueRole(this.parseValueRole(attrs));
        this.getBuilder().editor(this.parsePropertyEditor(attrs));
        this.getBuilder().core(this.parsePropertyCore(attrs));
        this.getBuilder().bundle(this.getEffectiveBundle(), "property.");
        this.getBuilder().descriptorFromParent(this.beanInfo.getBeanClass());
        if (this.validatePropertiesOnBoot && this.beanInfo.getPropertyDescriptor(this.getName()) == null) {
            throw new ParseException("Attribute 'name' with value '" + this.getName() + "' does not reference a valid property. [" + this.beanInfo + "]", this.getLocator());
        }
    }

    public String getEffectiveBundle() {
        if (this.getBundle() != null) {
            return this.getBundle();
        }
        return this.bundleLocation;
    }

    private ReportPreProcessorPropertyCore parsePropertyCore(Attributes attrs) throws ParseException {
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            ReportPreProcessorPropertyCore core = (ReportPreProcessorPropertyCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, ReportPreProcessorPropertyReadHandler.class, ReportPreProcessorPropertyCore.class);
            if (core == null) {
                throw new ParseException("Attribute 'impl' references a invalid ReportPreProcessorPropertyCore implementation.", this.getLocator());
            }
            return core;
        }
        return new DefaultReportPreProcessorPropertyCore();
    }

    private Class<? extends PropertyEditor> parsePropertyEditor(Attributes attrs) {
        String propertyEditorClass = attrs.getValue(this.getUri(), "propertyEditor");
        return ObjectUtilities.loadAndValidate((String)propertyEditorClass, ExpressionPropertyReadHandler.class, PropertyEditor.class);
    }

    private String parseValueRole(Attributes attrs) {
        String valueRole = attrs.getValue(this.getUri(), "value-role");
        if (valueRole == null) {
            valueRole = "Value";
        }
        return valueRole;
    }

    public boolean isMandatory() {
        return this.getBuilder().isMandatory();
    }

    public String getValueRole() {
        return this.getBuilder().getValueRole();
    }

    public ReportPreProcessorPropertyMetaData getObject() throws SAXException {
        return new DefaultReportPreProcessorPropertyMetaData(this.getBuilder());
    }
}

