/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultStyleKeyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.StyleMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroup;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StyleGroupRefReadHandler
extends AbstractXmlReadHandler {
    private Map<StyleKey, StyleMetaData> styles;
    private GlobalMetaDefinition styleGroups;
    private String bundle;

    public StyleGroupRefReadHandler(Map<StyleKey, StyleMetaData> styles, GlobalMetaDefinition styleGroups, String bundle) {
        this.styles = styles;
        this.styleGroups = styleGroups;
        this.bundle = bundle;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String name = attrs.getValue(this.getUri(), "ref");
        if (name == null) {
            throw new ParseException("Attribute 'ref' is undefined", this.getLocator());
        }
        StyleGroup group = this.styleGroups.getStyleGroup(name);
        if (group == null) {
            throw new ParseException("Attribute 'ref' is invalid. There is no style-group '" + name + "' defined.", this.getLocator());
        }
        for (StyleMetaDataBuilder handler : group.getMetaData()) {
            StyleKey key = handler.getKey();
            if (handler.getBundleLocation() == null) {
                handler = (StyleMetaDataBuilder)((StyleMetaDataBuilder)handler.clone()).bundle(this.bundle, "style.");
            }
            DefaultStyleKeyMetaData metaData = new DefaultStyleKeyMetaData(handler);
            this.styles.put(key, metaData);
        }
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

