/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class LengthPropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Float value;

    @Override
    public void setValue(Object value) {
        Float oldValue = this.value;
        this.value = !(value instanceof Float) ? null : (Float)value;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.value.longValue() == Long.MAX_VALUE || this.value.longValue() == Long.MIN_VALUE) {
            return "auto";
        }
        if (this.value.floatValue() < 0.0f) {
            return -this.value.floatValue() + "%";
        }
        return this.value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(LengthPropertyEditor.parseRelativeFloat(text));
    }

    public static Float parseRelativeFloat(String value) {
        if (value == null) {
            return null;
        }
        if ("auto".equalsIgnoreCase(value)) {
            return new Float(-9.223372E18f);
        }
        try {
            String tvalue = value.trim();
            if (tvalue.length() > 0 && tvalue.charAt(tvalue.length() - 1) == '%') {
                String number = tvalue.substring(0, tvalue.length() - 1);
                float f = Float.parseFloat(number.trim());
                return new Float(-f);
            }
            float f = Float.parseFloat(tvalue);
            return new Float(f);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

