/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.TimeZoneValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class TimeZonePropertyEditor
implements PropertyEditor {
    private TimeZoneValueConverter valueConverter;
    private TimeZone value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TimeZonePropertyEditor() {
        this.valueConverter = new TimeZoneValueConverter();
    }

    @Override
    public void setValue(Object value) {
        TimeZone oldValue = this.value;
        this.value = value instanceof TimeZone ? (TimeZone)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value != null) {
            return TimeZone.class.getName() + ".getTimeZone(\"" + this.value.getID() + "\")";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    @Override
    public String[] getTags() {
        return TimeZone.getAvailableIDs();
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

