/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.RequestFocusHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class PreviewFrame
extends JFrame {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private JLabel pageLabel;
    private ReportProgressDialog progressDialog;
    private Messages messages;

    public PreviewFrame() {
        this.init();
    }

    public PreviewFrame(MasterReport report) {
        this.init();
        this.setReportJob(report);
    }

    protected void init() {
        this.addComponentListener(new RequestFocusHandler());
        this.messages = new Messages(this.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        this.previewPane = new PreviewPane();
        this.previewPane.setDeferredRepagination(true);
        this.addComponentListener(new TriggerPaginationListener(this.previewPane));
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.pageLabel = new JLabel();
        this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean progressBarEnabled = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.ProgressBarEnabled"));
        boolean progressDialogEnabled = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.ProgressDialogEnabled"));
        if (progressBarEnabled) {
            this.progressBar = new ReportProgressBar();
            this.progressBar.setVisible(false);
            this.previewPane.addReportProgressListener(this.progressBar);
            this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        } else {
            this.progressBar = null;
        }
        if (progressDialogEnabled) {
            this.progressDialog = new ReportProgressDialog(this);
            MasterReport reportJob = this.previewPane.getReportJob();
            if (reportJob == null || reportJob.getTitle() == null) {
                this.progressDialog.setTitle(this.messages.getString("ProgressDialog.EMPTY_TITLE"));
                this.progressDialog.setMessage(this.messages.getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                this.progressDialog.setTitle(this.messages.getString("ProgressDialog.TITLE", (Object)reportJob.getTitle()));
                this.progressDialog.setMessage(this.messages.getString("ProgressDialog.TITLE", (Object)reportJob.getTitle()));
            }
            this.progressDialog.pack();
        } else {
            this.progressDialog = null;
        }
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        if (this.progressBar != null) {
            extensionArea.add(this.progressBar);
        }
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
        this.updateMenu(this.previewPane.getMenu());
        this.setTitle(this.previewPane.getTitle());
        this.statusBar.setIconTheme(this.previewPane.getIconTheme());
        this.statusBar.setStatus(this.previewPane.getStatusType(), this.previewPane.getStatusText());
    }

    private void updateMenu(JMenu[] menus) {
        if (menus != null && menus.length > 0) {
            JMenuBar menuBar = new JMenuBar();
            for (int i = 0; i < menus.length; ++i) {
                JMenu menu = menus[i];
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
        } else {
            this.setJMenuBar(null);
        }
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public MasterReport getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(MasterReport reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.previewPane.setClosed(true);
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public boolean isToolbarFloatable() {
        return this.previewPane.isToolbarFloatable();
    }

    public void setToolbarFloatable(boolean toolbarFloatable) {
        this.previewPane.setToolbarFloatable(toolbarFloatable);
    }

    public double getZoom() {
        return this.previewPane.getZoom();
    }

    public void setZoom(double zoom) {
        this.previewPane.setZoom(zoom);
    }

    private static class TriggerPaginationListener
    extends ComponentAdapter {
        private PreviewPane pane;

        private TriggerPaginationListener(PreviewPane pane) {
            this.pane = pane;
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (this.pane.isDeferredRepagination()) {
                this.pane.startPagination();
            }
        }
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        protected PreviewPanePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = PreviewFrame.this.previewPane.getMenu();
                if (menus != null && menus.length > 0) {
                    JMenuBar menuBar = new JMenuBar();
                    for (int i = 0; i < menus.length; ++i) {
                        JMenu menu = menus[i];
                        menuBar.add(menu);
                    }
                    PreviewFrame.this.setJMenuBar(menuBar);
                } else {
                    PreviewFrame.this.setJMenuBar(null);
                }
                return;
            }
            if ("title".equals(propertyName)) {
                PreviewFrame.this.setTitle(PreviewFrame.this.previewPane.getTitle());
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                PreviewFrame.this.statusBar.setStatus(PreviewFrame.this.previewPane.getStatusType(), PreviewFrame.this.previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                PreviewFrame.this.statusBar.setIconTheme(PreviewFrame.this.previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewFrame.this.pageLabel.setVisible(false);
                    PreviewFrame.this.statusBar.setStatus(StatusType.INFORMATION, PreviewFrame.this.messages.getString("PreviewFrame.USER_PAGINATING"));
                    if (PreviewFrame.this.progressBar != null) {
                        PreviewFrame.this.previewPane.addReportProgressListener(PreviewFrame.this.progressBar);
                        PreviewFrame.this.progressBar.setOnlyPagination(true);
                        PreviewFrame.this.progressBar.setVisible(true);
                        PreviewFrame.this.progressBar.revalidate();
                    }
                    if (PreviewFrame.this.progressDialog != null) {
                        PreviewFrame.this.previewPane.addReportProgressListener(PreviewFrame.this.progressDialog);
                        LibSwingUtil.centerDialogInParent((Dialog)PreviewFrame.this.progressDialog);
                        PreviewFrame.this.progressDialog.setOnlyPagination(true);
                        PreviewFrame.this.progressDialog.setVisible(true);
                    }
                } else {
                    PreviewFrame.this.pageLabel.setVisible(true);
                    PreviewFrame.this.statusBar.setStatus(StatusType.NONE, "");
                    if (PreviewFrame.this.progressBar != null) {
                        PreviewFrame.this.progressBar.setVisible(false);
                        PreviewFrame.this.progressBar.setOnlyPagination(false);
                        PreviewFrame.this.previewPane.removeReportProgressListener(PreviewFrame.this.progressBar);
                        PreviewFrame.this.progressBar.revalidate();
                    }
                    if (PreviewFrame.this.progressDialog != null) {
                        PreviewFrame.this.previewPane.removeReportProgressListener(PreviewFrame.this.progressDialog);
                        PreviewFrame.this.progressDialog.setOnlyPagination(false);
                        PreviewFrame.this.progressDialog.setVisible(false);
                    }
                }
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewFrame.this.pageLabel.setText(PreviewFrame.this.previewPane.getPageNumber() + "/" + PreviewFrame.this.previewPane.getNumberOfPages());
                return;
            }
            if ("closed".equals(propertyName)) {
                if (PreviewFrame.this.previewPane.isClosed()) {
                    PreviewFrame.this.setVisible(false);
                    PreviewFrame.this.dispose();
                } else {
                    PreviewFrame.this.setVisible(true);
                }
            }
        }
    }
}

