/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ReportProgressDialog
extends JDialog
implements ReportProgressListener {
    private JLabel messageCarrier;
    private JLabel passCountMessage;
    private JLabel pageCountMessage;
    private JLabel rowCountMessage;
    private JProgressBar progressBar;
    private MessageFormat pageMessageFormatter;
    private MessageFormat rowsMessageFormatter;
    private MessageFormat passMessageFormatter;
    private int lastPage;
    private int lastActivity;
    private int lastMaxRow;
    private Integer lastMaxRowInteger;
    private String layoutText;
    private String outputText;
    private Messages messages;
    private boolean onlyPagination;
    private ScreenUpdateRunnable updateRunnable;

    public ReportProgressDialog(Dialog dialog) {
        super(dialog);
        this.setLocale(dialog.getLocale());
        this.initConstructor();
    }

    public ReportProgressDialog(Frame frame) {
        super(frame);
        this.setLocale(frame.getLocale());
        this.initConstructor();
    }

    public ReportProgressDialog() {
        this.initConstructor();
    }

    public boolean isOnlyPagination() {
        return this.onlyPagination;
    }

    public void setOnlyPagination(boolean onlyPagination) {
        this.onlyPagination = onlyPagination;
    }

    private void initConstructor() {
        this.updateRunnable = new ScreenUpdateRunnable();
        this.messages = new Messages(this.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
        this.initialize();
        this.addWindowListener(new ToFrontHandler());
        this.setOutputText(this.messages.getString("progress-dialog.perform-output"));
        this.setLayoutText(this.messages.getString("progress-dialog.prepare-layout"));
        this.lastActivity = -1;
        this.lastMaxRow = -1;
        this.lastPage = -1;
        this.pack();
        LibSwingUtil.centerDialogInParent((Dialog)this);
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new GridBagLayout());
        this.pageMessageFormatter = new MessageFormat(this.messages.getString("progress-dialog.page-label"));
        this.rowsMessageFormatter = new MessageFormat(this.messages.getString("progress-dialog.rows-label"));
        this.passMessageFormatter = new MessageFormat(this.messages.getString("progress-dialog.pass-label-0"));
        this.messageCarrier = new JLabel(" ");
        this.passCountMessage = new JLabel(" ");
        this.rowCountMessage = new JLabel(" ");
        this.pageCountMessage = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setStringPainted(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 5, 1);
        gbc.ipadx = 200;
        contentPane.add((Component)this.messageCarrier, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 16;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.passCountMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.progressBar, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.pageCountMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 10, 1, 1);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        contentPane.add((Component)this.rowCountMessage, gbc);
        this.setContentPane(contentPane);
    }

    public String getMessage() {
        return this.messageCarrier.getText();
    }

    public void setMessage(String message) {
        this.messageCarrier.setText(message);
    }

    protected void updatePageMessage(int page) {
        if (this.lastPage != page) {
            Object[] parameters = new Object[]{new Integer(page)};
            this.pageCountMessage.setText(this.pageMessageFormatter.format(parameters));
            this.lastPage = page;
        }
    }

    protected void updateRowsMessage(int rows, int maxRows) {
        if (maxRows != this.lastMaxRow) {
            this.lastMaxRowInteger = new Integer(maxRows);
            this.lastMaxRow = maxRows;
        }
        Object[] parameters = new Object[]{new Integer(rows), this.lastMaxRowInteger};
        this.rowCountMessage.setText(this.rowsMessageFormatter.format(parameters));
    }

    protected void updateActivityMessage(int activity) {
        if (this.lastActivity != activity) {
            this.lastActivity = activity;
            Object[] parameters = new Object[]{new Integer(activity)};
            this.passCountMessage.setText(this.passMessageFormatter.format(parameters));
        }
    }

    protected void updateProgressBar(ReportProgressEvent event) {
        this.progressBar.setValue((int)ReportProgressEvent.computePercentageComplete(event, this.isOnlyPagination()));
    }

    protected final JLabel getPassCountMessage() {
        return this.passCountMessage;
    }

    protected final JLabel getPageCountMessage() {
        return this.pageCountMessage;
    }

    protected final JLabel getRowCountMessage() {
        return this.rowCountMessage;
    }

    protected final MessageFormat getPageMessageFormatter() {
        return this.pageMessageFormatter;
    }

    protected final MessageFormat getRowsMessageFormatter() {
        return this.rowsMessageFormatter;
    }

    protected final MessageFormat getPassMessageFormatter() {
        return this.passMessageFormatter;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public void setOutputText(String outputText) {
        if (outputText == null) {
            throw new NullPointerException(this.messages.getErrorString("ReportProgressDialog.ERROR_0001_OUTPUT_TEXT_NULL", new String[0]));
        }
        this.outputText = outputText;
    }

    public String getLayoutText() {
        return this.layoutText;
    }

    public void setLayoutText(String layoutText) {
        if (layoutText == null) {
            throw new NullPointerException(this.messages.getErrorString("ReportProgressDialog.ERROR_0002_LAYOUT_TEXT_NULL", new String[0]));
        }
        this.layoutText = layoutText;
    }

    protected boolean isSameMaxRow(int row) {
        return this.lastMaxRow == row;
    }

    @Override
    public void reportProcessingStarted(ReportProgressEvent event) {
        this.postUpdate(event);
    }

    @Override
    public void reportProcessingUpdate(ReportProgressEvent event) {
        this.postUpdate(event);
    }

    @Override
    public void reportProcessingFinished(ReportProgressEvent event) {
        this.postUpdate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpdate(ReportProgressEvent event) {
        ScreenUpdateRunnable screenUpdateRunnable = this.updateRunnable;
        synchronized (screenUpdateRunnable) {
            if (this.updateRunnable.update(event)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.updateRunnable.run();
                } else {
                    SwingUtilities.invokeLater(this.updateRunnable);
                }
            }
        }
    }

    public void setVisibleInEDT(boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (b) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new ShowHideTask(this, b));
            }
            catch (Exception e) {
                if (b) {
                    this.setVisible(true);
                }
                this.setVisible(false);
            }
        }
    }

    private static class ShowHideTask
    implements Runnable {
        private Dialog parent;
        private boolean visible;

        private ShowHideTask(Dialog parent, boolean visible) {
            this.parent = parent;
            this.visible = visible;
        }

        @Override
        public void run() {
            if (this.visible) {
                this.parent.setVisible(true);
            } else {
                this.parent.setVisible(false);
            }
        }
    }

    private static class ToFrontHandler
    extends WindowAdapter {
        protected ToFrontHandler() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            e.getWindow().toFront();
        }
    }

    private class ScreenUpdateRunnable
    implements Runnable {
        private ReportProgressEvent event;

        protected ScreenUpdateRunnable() {
        }

        @Override
        public synchronized void run() {
            if (this.event == null) {
                return;
            }
            ReportProgressDialog.this.updatePageMessage(this.event.getPage());
            ReportProgressDialog.this.updateRowsMessage(this.event.getRow(), this.event.getMaximumRow());
            ReportProgressDialog.this.updateActivityMessage(this.event.getActivity());
            ReportProgressDialog.this.updateProgressBar(this.event);
            this.event = null;
        }

        public synchronized boolean update(ReportProgressEvent event) {
            boolean retval = this.event == null;
            this.event = event;
            return retval;
        }
    }
}

