/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.pdf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.GuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class PdfExportDialog
extends AbstractExportDialog {
    private static final Log logger = LogFactory.getLog(PdfExportDialog.class);
    private static final int CBMODEL_NOPRINTING = 0;
    private static final int CBMODEL_DEGRADED = 1;
    private static final int CBMODEL_FULL = 2;
    private JRadioButton rbSecurityNone;
    private JRadioButton rbSecurity40Bit;
    private JRadioButton rbSecurity128Bit;
    private JTextField txUserPassword;
    private JTextField txOwnerPassword;
    private JTextField txConfUserPassword;
    private JTextField txConfOwnerPassword;
    private JCheckBox cxAllowCopy;
    private JCheckBox cxAllowScreenReaders;
    private JComboBox cbAllowPrinting;
    private JCheckBox cxAllowAssembly;
    private JCheckBox cxAllowModifyContents;
    private JCheckBox cxAllowModifyAnnotations;
    private JCheckBox cxAllowFillIn;
    private EncodingComboBoxModel encodingModel;
    private JFileChooser fileChooser;
    private JTextField txTitle;
    private JTextField txAuthor;
    private static final String PDF_FILE_EXTENSION = ".pdf";
    private JStatusBar statusBar;
    private JTextField txFilename;
    private DefaultComboBoxModel printingModel;
    private JComboBox cbEncoding;
    private JCheckBox cxEmbedded;
    private JTextField txKeywords;
    private JTextField txDescription;

    public PdfExportDialog() {
        this.initializeComponents();
    }

    public PdfExportDialog(Frame owner) {
        super(owner);
        this.initializeComponents();
    }

    public PdfExportDialog(Dialog owner) {
        super(owner);
        this.initializeComponents();
    }

    private JPanel createMetaDataPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        JLabel lblAuthor = new JLabel(this.getResources().getString("pdfsavedialog.author"));
        JLabel lblTitel = new JLabel(this.getResources().getString("pdfsavedialog.title"));
        JLabel lblKeywords = new JLabel(this.getResources().getString("pdfsavedialog.keywords"));
        JLabel lblDescription = new JLabel(this.getResources().getString("pdfsavedialog.description"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblTitel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblKeywords, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblDescription, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txTitle, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txKeywords, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txDescription, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    private void initializeComponents() {
        this.setTitle(this.getResources().getString("pdfsavedialog.dialogtitle"));
        this.txAuthor = new JTextField();
        this.txAuthor.setColumns(40);
        this.txTitle = new JTextField();
        this.txTitle.setColumns(40);
        this.txKeywords = new JTextField();
        this.txKeywords.setColumns(40);
        this.txDescription = new JTextField();
        this.txDescription.setColumns(40);
        this.rbSecurityNone = new JRadioButton(this.getResources().getString("pdfsavedialog.securityNone"));
        this.rbSecurity40Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security40bit"));
        this.rbSecurity128Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security128bit"));
        ActionSecuritySelection securitySelectAction = new ActionSecuritySelection();
        this.rbSecurityNone.addActionListener(securitySelectAction);
        this.rbSecurity40Bit.addActionListener(securitySelectAction);
        this.rbSecurity128Bit.addActionListener(securitySelectAction);
        this.rbSecurity128Bit.setSelected(true);
        this.txUserPassword = new JPasswordField();
        this.txConfUserPassword = new JPasswordField();
        this.txOwnerPassword = new JPasswordField();
        this.txConfOwnerPassword = new JPasswordField();
        this.cxAllowCopy = new JCheckBox(this.getResources().getString("pdfsavedialog.allowCopy"));
        this.cbAllowPrinting = new JComboBox(this.getPrintingComboBoxModel());
        this.cxAllowScreenReaders = new JCheckBox(this.getResources().getString("pdfsavedialog.allowScreenreader"));
        this.cxAllowAssembly = new JCheckBox(this.getResources().getString("pdfsavedialog.allowAssembly"));
        this.cxAllowModifyContents = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyContents"));
        this.cxAllowModifyAnnotations = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyAnnotations"));
        this.cxAllowFillIn = new JCheckBox(this.getResources().getString("pdfsavedialog.allowFillIn"));
        this.txFilename = new JTextField();
        this.txFilename.setColumns(40);
        this.statusBar = new JStatusBar();
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        this.cxEmbedded = new JCheckBox(this.getResources().getString("pdfsavedialog.embedfonts"));
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerTextField(this.txConfOwnerPassword);
        this.getFormValidator().registerTextField(this.txConfUserPassword);
        this.getFormValidator().registerTextField(this.txUserPassword);
        this.getFormValidator().registerTextField(this.txOwnerPassword);
        JPanel exportPane = this.createExportPanel();
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean advancedSettingsTabAvail = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.pdf.AdvancedSettingsAvailable"));
        boolean metaDataSettingsTabAvail = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.pdf.MetaDataSettingsAvailable"));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(this.getResources().getString("pdfsavedialog.export-settings"), exportPane);
        tabbedPane.add(this.getResources().getString("pdfsavedialog.parameters"), this.getParametersPanel());
        if (metaDataSettingsTabAvail) {
            tabbedPane.add(this.getResources().getString("pdfsavedialog.metadata-settings"), this.createMetaDataPanel());
        }
        if (advancedSettingsTabAvail) {
            tabbedPane.add(this.getResources().getString("pdfsavedialog.advanced-settings"), this.createAdvancedPanel());
        }
        this.setContentPane(this.createContentPane(tabbedPane));
    }

    private JPanel createExportPanel() {
        JButton btnSelect = new JButton(new ActionSelectFile(this.getResources()));
        JLabel lblFileName = new JLabel(this.getResources().getString("pdfsavedialog.filename"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 1, 1);
        mainPanel.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.insets = new Insets(3, 1, 1, 1);
        mainPanel.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        mainPanel.add((Component)btnSelect, gbc);
        JPanel advancedPaneCarrier = new JPanel();
        advancedPaneCarrier.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        advancedPaneCarrier.setLayout(new BorderLayout());
        advancedPaneCarrier.add((Component)mainPanel, "North");
        return advancedPaneCarrier;
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    protected boolean performConfirm() {
        String filename = this.txFilename.getText();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "pdfsavedialog.targetOverwriteConfirmation";
            String key2 = "pdfsavedialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteConfirmation"), this.txFilename.getText()), this.getResources().getString("pdfsavedialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return !this.getEncryptionValue().equals("128bit") && !this.getEncryptionValue().equals("40bit") || this.txOwnerPassword.getText().trim().length() != 0 || JOptionPane.showConfirmDialog(this, this.getResources().getString("pdfsavedialog.ownerpasswordEmpty"), this.getResources().getString("pdfsavedialog.warningTitle"), 0, 2) != 1;
    }

    @Override
    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.txFilename.getText();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("pdfsavedialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("pdfsavedialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("pdfsavedialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        if (this.getEncryptionValue().equals("128bit") || this.getEncryptionValue().equals("40bit")) {
            if (!this.txUserPassword.getText().equals(this.txConfUserPassword.getText())) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("pdfsavedialog.userpasswordNoMatch"));
                return false;
            }
            if (!this.txOwnerPassword.getText().equals(this.txConfOwnerPassword.getText())) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("pdfsavedialog.ownerpasswordNoMatch"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected void initializeFromJob(MasterReport job, GuiContext guiContext) {
        this.statusBar.setIconTheme(guiContext.getIconTheme());
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.sort();
        this.cbEncoding.setModel(this.encodingModel);
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.pdf.";
    }

    @Override
    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration config = new DefaultConfiguration();
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Keywords", this.txKeywords.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Description", this.txDescription.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Author", this.txAuthor.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Title", this.txTitle.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.pdf.TargetFileName", this.txFilename.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Encoding", this.encodingModel.getSelectedEncoding());
        config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PrintLevel", this.getPrintLevel());
        config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Encryption", this.getEncryptionValue());
        config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.UserPassword", this.txUserPassword.getText());
        config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.OwnerPassword", this.txOwnerPassword.getText());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowAssembly", String.valueOf(this.cxAllowAssembly.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowCopy", String.valueOf(this.cxAllowCopy.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowFillIn", String.valueOf(this.cxAllowFillIn.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyAnnotations", String.valueOf(this.cxAllowModifyAnnotations.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyContents", String.valueOf(this.cxAllowModifyContents.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowScreenReaders", String.valueOf(this.cxAllowScreenReaders.isSelected()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.EmbedFonts", String.valueOf(this.cxEmbedded.isSelected()));
        return config;
    }

    @Override
    protected void setDialogContents(Configuration config) {
        this.txFilename.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.pdf.TargetFileName"));
        String encoding = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Encoding");
        if (encoding != null && encoding.length() > 0) {
            this.encodingModel.setSelectedEncoding(encoding);
        }
        this.setPrintLevel(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.security.PrintLevel"));
        this.setEncryptionValue(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.security.Encryption"));
        this.txUserPassword.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.UserPassword"));
        this.txOwnerPassword.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.OwnerPassword"));
        this.txConfUserPassword.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.UserPassword"));
        this.txConfOwnerPassword.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.OwnerPassword"));
        this.cxAllowAssembly.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowAssembly")));
        this.cxAllowCopy.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowCopy")));
        this.cxAllowFillIn.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowFillIn")));
        this.cxAllowModifyAnnotations.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyAnnotations")));
        this.cxAllowModifyContents.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowModifyContents")));
        this.cxAllowScreenReaders.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AllowScreenReaders")));
        this.cxEmbedded.setSelected("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.EmbedFonts")));
        this.txTitle.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Title", config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Title")));
        this.txAuthor.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Author", config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Author")));
        this.txKeywords.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Keywords", config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Keywords")));
        this.txDescription.setText(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Description", config.getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.Description")));
    }

    @Override
    protected String getConfigurationSuffix() {
        return "_pdf_export";
    }

    @Override
    public void clear() {
        this.txConfOwnerPassword.setText("");
        this.txConfUserPassword.setText("");
        this.txFilename.setText("");
        this.txOwnerPassword.setText("");
        this.txUserPassword.setText("");
        this.cxAllowAssembly.setSelected(false);
        this.cxAllowCopy.setSelected(false);
        this.cbAllowPrinting.setSelectedIndex(0);
        this.cxAllowFillIn.setSelected(false);
        this.cxAllowModifyAnnotations.setSelected(false);
        this.cxAllowModifyContents.setSelected(false);
        this.cxAllowScreenReaders.setSelected(false);
        this.cxEmbedded.setSelected(false);
        this.rbSecurityNone.setSelected(true);
        this.updateSecurityPanelEnabled();
        String plattformDefaultEncoding = EncodingRegistry.getPlatformDefaultEncoding();
        this.encodingModel.setSelectedEncoding(plattformDefaultEncoding);
        this.txAuthor.setText(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("user.name", ""));
        this.txFilename.setText("");
        this.txTitle.setText("");
        this.txDescription.setText("");
        this.txKeywords.setText("");
    }

    @Override
    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.pdf.messages.messages";
    }

    protected void updateSecurityPanelEnabled() {
        boolean b = !this.rbSecurityNone.isSelected();
        this.txUserPassword.setEnabled(b);
        this.txOwnerPassword.setEnabled(b);
        this.txConfOwnerPassword.setEnabled(b);
        this.txConfUserPassword.setEnabled(b);
        this.cxAllowAssembly.setEnabled(b);
        this.cxAllowCopy.setEnabled(b);
        this.cbAllowPrinting.setEnabled(b);
        this.cxAllowFillIn.setEnabled(b);
        this.cxAllowModifyAnnotations.setEnabled(b);
        this.cxAllowModifyContents.setEnabled(b);
        this.cxAllowScreenReaders.setEnabled(b);
    }

    private JPanel createAdvancedPanel() {
        JLabel lblEncoding = new JLabel(this.getResources().getString("pdfsavedialog.encoding"));
        JPanel encodingPanel = new JPanel();
        encodingPanel.setBorder(BorderFactory.createTitledBorder(this.getResources().getString("pdfsavedialog.export-options")));
        encodingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        encodingPanel.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 80;
        gbc.insets = new Insets(1, 1, 1, 1);
        encodingPanel.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 80;
        gbc.insets = new Insets(1, 1, 1, 1);
        encodingPanel.add((Component)this.cxEmbedded, gbc);
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new GridBagLayout());
        securityPanel.setBorder(BorderFactory.createTitledBorder(this.getResources().getString("pdfsavedialog.security")));
        JLabel lblUserPass = new JLabel(this.getResources().getString("pdfsavedialog.userpassword"));
        JLabel lblUserPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.userpasswordconfirm"));
        JLabel lblOwnerPass = new JLabel(this.getResources().getString("pdfsavedialog.ownerpassword"));
        JLabel lblOwnerPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.ownerpasswordconfirm"));
        JLabel lbAllowPrinting = new JLabel(this.getResources().getString("pdfsavedialog.allowPrinting"));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.createSecurityConfigPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 80;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.ipadx = 80;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.ipadx = 80;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowCopy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowScreenReaders, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowFillIn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowAssembly, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyContents, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyAnnotations, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 7;
        gbc.anchor = 17;
        securityPanel.add((Component)lbAllowPrinting, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.gridy = 7;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cbAllowPrinting, gbc);
        JPanel advancedCarrier2 = new JPanel();
        advancedCarrier2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 5, 1);
        advancedCarrier2.add((Component)encodingPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        advancedCarrier2.add((Component)securityPanel, gbc);
        JPanel advancedPaneCarrier = new JPanel();
        advancedPaneCarrier.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        advancedPaneCarrier.setLayout(new BorderLayout());
        advancedPaneCarrier.add((Component)advancedCarrier2, "North");
        return advancedPaneCarrier;
    }

    private JPanel createSecurityConfigPanel() {
        JPanel pnlSecurityConfig = new JPanel();
        pnlSecurityConfig.setLayout(new GridLayout());
        pnlSecurityConfig.add(this.rbSecurityNone);
        pnlSecurityConfig.add(this.rbSecurity40Bit);
        pnlSecurityConfig.add(this.rbSecurity128Bit);
        ButtonGroup btGrpSecurity = new ButtonGroup();
        btGrpSecurity.add(this.rbSecurity128Bit);
        btGrpSecurity.add(this.rbSecurity40Bit);
        btGrpSecurity.add(this.rbSecurityNone);
        return pnlSecurityConfig;
    }

    private DefaultComboBoxModel getPrintingComboBoxModel() {
        if (this.printingModel == null) {
            Object[] data = new Object[]{this.getResources().getString("pdfsavedialog.option.noprinting"), this.getResources().getString("pdfsavedialog.option.degradedprinting"), this.getResources().getString("pdfsavedialog.option.fullprinting")};
            this.printingModel = new DefaultComboBoxModel<Object>(data);
        }
        return this.printingModel;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(PDF_FILE_EXTENSION, this.getResources().getString("file.save.pdfdescription"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        File file = new File(this.txFilename.getText());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!selFileName.toLowerCase().endsWith(PDF_FILE_EXTENSION)) {
                selFileName = selFileName + PDF_FILE_EXTENSION;
            }
            this.txFilename.setText(selFileName);
        }
    }

    public void setPrintLevel(String printLevel) {
        if ("full".equals(printLevel)) {
            this.cbAllowPrinting.setSelectedIndex(2);
        } else if ("degraded".equals(printLevel)) {
            this.cbAllowPrinting.setSelectedIndex(1);
        } else {
            this.cbAllowPrinting.setSelectedIndex(0);
        }
    }

    public String getPrintLevel() {
        if (this.cbAllowPrinting.getSelectedIndex() == 2) {
            return "full";
        }
        if (this.cbAllowPrinting.getSelectedIndex() == 1) {
            return "degraded";
        }
        return "none";
    }

    public String getEncryptionValue() {
        if (this.rbSecurity40Bit.isSelected()) {
            return "40bit";
        }
        if (this.rbSecurity128Bit.isSelected()) {
            return "128bit";
        }
        return "none";
    }

    public void setEncryptionValue(String b) {
        if (b != null) {
            if (b.equals("128bit")) {
                this.rbSecurity128Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (b.equals("40bit")) {
                this.rbSecurity40Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (!b.equals("none")) {
                logger.warn((Object)("Invalid encryption value entered. " + b));
            }
        }
        this.rbSecurityNone.setSelected(true);
        this.updateSecurityPanelEnabled();
    }

    private class ActionSelectFile
    extends AbstractAction {
        protected ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("pdfsavedialog.selectFile"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfExportDialog.this.performSelectFile();
        }
    }

    private class ActionSecuritySelection
    extends AbstractAction {
        protected ActionSecuritySelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PdfExportDialog.this.updateSecurityPanelEnabled();
        }
    }
}

