/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceMgmtService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceMgmtServiceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DuplicateDatasourceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.NonExistingDatasourceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.SerializedConnection;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class EditDataSourceMgmtService
implements DataSourceMgmtService {
    private DataSourceMgmtService parent;
    private Set<String> deletedMembersById;
    private HashMap<String, SerializedConnection> editedMembers;

    public EditDataSourceMgmtService() {
        this((DataSourceMgmtService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceMgmtService.class));
    }

    public EditDataSourceMgmtService(DataSourceMgmtService parent) {
        ArgumentNullException.validate((String)"parent", (Object)parent);
        this.parent = parent;
        this.deletedMembersById = new HashSet<String>();
        this.editedMembers = new HashMap();
    }

    @Override
    public String createDatasource(IDatabaseConnection databaseConnection) throws DuplicateDatasourceException, DatasourceMgmtServiceException {
        String name = databaseConnection.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException();
        }
        try {
            if (this.getDatasourceByName(name) != null) {
                throw new DuplicateDatasourceException();
            }
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            // empty catch block
        }
        String id = UUID.randomUUID().toString();
        databaseConnection.setId(id);
        this.editedMembers.put(id, new SerializedConnection(databaseConnection));
        return id;
    }

    @Override
    public void deleteDatasourceById(String id) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException();
        }
        if (this.parent.getDatasourceIds().contains(id)) {
            this.deletedMembersById.add(id);
        } else if (!this.editedMembers.containsKey(id)) {
            throw new NonExistingDatasourceException();
        }
        this.editedMembers.remove(id);
    }

    @Override
    public IDatabaseConnection getDatasourceByName(String name) throws DatasourceMgmtServiceException {
        IDatabaseConnection dataSource = this.parent.getDatasourceByName(name);
        if (this.deletedMembersById.contains(dataSource.getId())) {
            throw new NonExistingDatasourceException();
        }
        return dataSource;
    }

    @Override
    public IDatabaseConnection getDatasourceById(String id) throws DatasourceMgmtServiceException {
        if (this.deletedMembersById.contains(id)) {
            throw new NonExistingDatasourceException();
        }
        return this.parent.getDatasourceById(id);
    }

    @Override
    public List<IDatabaseConnection> getDatasources() throws DatasourceMgmtServiceException {
        ArrayList<IDatabaseConnection> connection = new ArrayList<IDatabaseConnection>(this.parent.getDatasources());
        Iterator<IDatabaseConnection> it = connection.iterator();
        while (it.hasNext()) {
            IDatabaseConnection databaseConnection = it.next();
            if (!this.deletedMembersById.contains(databaseConnection.getId())) continue;
            it.remove();
        }
        return connection;
    }

    @Override
    public List<String> getDatasourceIds() throws DatasourceMgmtServiceException {
        List<IDatabaseConnection> datasources = this.getDatasources();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < datasources.size(); ++i) {
            IDatabaseConnection connection = datasources.get(i);
            list.add(connection.getId());
        }
        return list;
    }

    @Override
    public String updateDatasourceById(String id, IDatabaseConnection databaseConnection) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException();
        }
        if (!ObjectUtilities.equal((Object)id, (Object)databaseConnection.getId())) {
            throw new IllegalArgumentException();
        }
        if (this.deletedMembersById.contains(id)) {
            throw new NonExistingDatasourceException();
        }
        this.editedMembers.put(id, new SerializedConnection(databaseConnection));
        return id;
    }

    public void commit() {
        for (String id : this.deletedMembersById) {
            this.parent.deleteDatasourceById(id);
        }
        HashSet<String> datasourceIds = new HashSet<String>(this.parent.getDatasourceIds());
        for (SerializedConnection c : this.editedMembers.values()) {
            IDatabaseConnection connection = c.getConnection();
            if (datasourceIds.contains(connection.getId())) {
                this.parent.updateDatasourceById(connection.getId(), connection);
                continue;
            }
            this.parent.createDatasource(connection);
        }
        this.deletedMembersById.clear();
        this.editedMembers.clear();
    }
}

