/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SimpleSQLReportDataFactory;

public class SQLDataFactoryCore
extends DefaultDataFactoryCore {
    private static final Log logger = LogFactory.getLog(SQLDataFactoryCore.class);
    private static final String CONNECTION_NAME = "::pentaho-reporting::name";

    @Override
    public String getDisplayConnectionName(DataFactoryMetaData metaData, DataFactory dataFactory) {
        SimpleSQLReportDataFactory sqlDataFactory = (SimpleSQLReportDataFactory)dataFactory;
        ConnectionProvider theConnectionProvider = sqlDataFactory.getConnectionProvider();
        if (theConnectionProvider instanceof DriverConnectionProvider) {
            DriverConnectionProvider theDriverConnectionProvider = (DriverConnectionProvider)theConnectionProvider;
            return theDriverConnectionProvider.getProperty(CONNECTION_NAME);
        }
        if (theConnectionProvider instanceof JndiConnectionProvider) {
            JndiConnectionProvider theDriverConnectionProvider = (JndiConnectionProvider)theConnectionProvider;
            return theDriverConnectionProvider.getConnectionPath();
        }
        return null;
    }

    @Override
    public Object getQueryHash(DataFactoryMetaData dataFactoryMetaData, DataFactory dataFactory, String queryName, DataRow parameter) {
        SimpleSQLReportDataFactory sqlDataFactory = (SimpleSQLReportDataFactory)dataFactory;
        return sqlDataFactory.getQueryHash(queryName, parameter);
    }

    @Override
    public String[] getReferencedFields(DataFactoryMetaData metaData, DataFactory element, String query, DataRow parameter) {
        try {
            SimpleSQLReportDataFactory sqlDataFactory = (SimpleSQLReportDataFactory)element;
            return sqlDataFactory.getReferencedFields(query, parameter);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)("Unable to compute referenced fields for query '" + query + "':"), (Throwable)e);
            return null;
        }
    }
}

