/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlImageBounds;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlStyleCache;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastGridLayout;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FastHtmlFormattedDataBuilder
extends AbstractFormattedDataBuilder {
    private final FastGridLayout gridLayout;
    private final FastHtmlPrinter htmlPrinter;
    private HashMap<InstanceID, FastHtmlImageBounds> recordedBounds;
    private HashMap<InstanceID, ReportElement> elements;
    private FastHtmlStyleCache styleCache;

    public FastHtmlFormattedDataBuilder(FastGridLayout gridLayout, FastHtmlPrinter htmlPrinter, HashMap<InstanceID, FastHtmlImageBounds> recordedBounds) {
        this.gridLayout = gridLayout;
        this.htmlPrinter = htmlPrinter;
        this.recordedBounds = recordedBounds;
        this.elements = new HashMap();
        this.styleCache = new FastHtmlStyleCache();
    }

    @Override
    public void compute(Band band, ExpressionRuntime runtime, OutputStream out) throws ReportProcessingException, ContentProcessingException, IOException {
        this.elements.clear();
        super.compute(band, runtime);
        this.htmlPrinter.startSection(band);
        this.htmlPrinter.print(runtime, this.gridLayout, this.elements, this.recordedBounds, this.styleCache);
        this.htmlPrinter.endSection(band, this.gridLayout);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        this.elements.put(element.getObjectID(), element);
    }
}

