/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;

public class FastHtmlStyleCache {
    private HashMap<Integer, AttributeList> rowAttributes = new HashMap();
    private HashMap<CellKey, CellStyle> cellAttributes = new HashMap();

    public AttributeList getRowAttributes(int row) {
        return this.rowAttributes.get(row);
    }

    public void putRowAttributes(int row, AttributeList attrs) {
        this.rowAttributes.put(row, attrs);
    }

    public CellStyle getCellAttributes(int row, int col) {
        return this.cellAttributes.get(new CellKey(row, col));
    }

    public void putCellAttributes(int row, int col, CellStyle attrs) {
        this.cellAttributes.put(new CellKey(row, col), attrs);
    }

    public static class CellStyle {
        private AttributeList cellAttributeList;
        private StyleBuilder.StyleCarrier[] cellStyle;

        public CellStyle(AttributeList cellAttributeList, StyleBuilder.StyleCarrier[] cellStyle) {
            this.cellAttributeList = cellAttributeList;
            this.cellStyle = cellStyle;
        }

        public AttributeList getCellAttributeList() {
            return this.cellAttributeList;
        }

        public StyleBuilder.StyleCarrier[] getCellStyle() {
            return this.cellStyle;
        }
    }

    private static class CellKey {
        private int row;
        private int col;

        private CellKey(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellKey cellKey = (CellKey)o;
            if (this.col != cellKey.col) {
                return false;
            }
            return this.row == cellKey.row;
        }

        public int hashCode() {
            int result = this.row;
            result = 31 * result + this.col;
            return result;
        }
    }
}

