/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.awt.Shape;
import java.io.IOException;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlImageBounds;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTagHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.RotatedTextDrawable;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class FastHtmlTextExtractor
extends FastTextExtractor {
    private final CharacterEntityParser characterEntityParser = HtmlCharacterEntities.getEntityParser();
    private final XmlWriter xmlWriter;
    private final StyleBuilder styleBuilder;
    private final HtmlTextExtractorHelper textExtractorHelper;
    private final BoxDefinitionFactory boxDefinitionFactory;
    private HashMap<InstanceID, FastHtmlImageBounds> recordedBounds;
    private boolean result;
    private HtmlTextExtractorState processStack;

    public FastHtmlTextExtractor(OutputProcessorMetaData metaData, XmlWriter xmlWriter, HtmlContentGenerator contentGenerator, HtmlTagHelper tagHelper) {
        this.xmlWriter = xmlWriter;
        this.styleBuilder = tagHelper.getStyleBuilder();
        this.textExtractorHelper = new HtmlTextExtractorHelper(tagHelper, xmlWriter, metaData, contentGenerator);
        this.boxDefinitionFactory = new BoxDefinitionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOutput(ReportElement content, StyleBuilder.StyleCarrier[] cellStyle, HashMap<InstanceID, FastHtmlImageBounds> recordedBounds, ExpressionRuntime runtime) throws IOException, ContentProcessingException {
        this.recordedBounds = recordedBounds;
        this.styleBuilder.clear();
        this.clearText();
        this.setRawResult(null);
        this.result = false;
        this.processStack = new HtmlTextExtractorState(null, false, cellStyle);
        this.textExtractorHelper.setFirstElement(content.getObjectID(), this.processStack);
        try {
            this.setRuntime(runtime);
            this.processInitialBox(content);
        }
        finally {
            this.setRuntime(null);
            this.processStack = null;
        }
        return this.result;
    }

    private void processInitialBox(ReportElement box) throws IOException, ContentProcessingException {
        if (!box.getComputedStyle().getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return;
        }
        SimpleStyleSheet styleSheet = box.getComputedStyle();
        String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (target != null) {
            this.textExtractorHelper.handleLinkOnElement(styleSheet, target);
            this.processStack = new HtmlTextExtractorState(this.processStack, true);
        } else {
            this.processStack = new HtmlTextExtractorState(this.processStack, false);
        }
        if (!Boolean.TRUE.equals(box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"))) {
            if (box instanceof Section) {
                this.traverseSection((Section)box);
            } else {
                this.inspectElement(box, true);
            }
        }
        if (this.processStack.isWrittenTag()) {
            this.xmlWriter.writeCloseTag();
        }
        this.processStack = this.processStack.getParent();
    }

    @Override
    protected boolean inspectStartSection(ReportElement box, boolean inlineSection) {
        BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(box.getComputedStyle());
        if (!inlineSection) {
            return this.textExtractorHelper.startBox(box.getObjectID(), box.getAttributes(), box.getComputedStyle(), boxDefinition, true);
        }
        return this.textExtractorHelper.startInlineBox(box.getObjectID(), box.getAttributes(), box.getComputedStyle(), boxDefinition);
    }

    @Override
    protected void inspectEndSection(ReportElement section, boolean inlineSection) {
        this.textExtractorHelper.finishBox(section.getObjectID(), section.getAttributes());
    }

    @Override
    protected void handleValueContent(ReportElement element, Object value, boolean inlineSection) throws ContentProcessingException {
        super.handleValueContent(element, value, inlineSection);
        if (value instanceof Shape) {
            this.handleShape(element, (Shape)value);
        } else if (value instanceof ImageContainer || value instanceof DrawableWrapper || value instanceof RotatedTextDrawable) {
            this.handleImage(element, value);
        } else {
            this.handleText(element, String.valueOf(value));
        }
    }

    private void handleText(ReportElement element, String text) throws ContentProcessingException {
        try {
            this.xmlWriter.writeText(this.characterEntityParser.encodeEntities(text));
            if (text.trim().length() > 0) {
                this.result = true;
            }
        }
        catch (IOException e) {
            throw new ContentProcessingException(e);
        }
    }

    protected void handleImage(ReportElement element, Object rawObject) throws ContentProcessingException {
        try {
            long height;
            long width;
            SimpleStyleSheet computedStyle;
            FastHtmlImageBounds cb = this.recordedBounds.get(element.getObjectID());
            if (cb == null) {
                return;
            }
            ReportAttributeMap<Object> attributes = element.getAttributes();
            if (this.textExtractorHelper.processRenderableReplacedContent(attributes, computedStyle = element.getComputedStyle(), width = cb.getWidth(), height = cb.getHeight(), cb.getContentWidth(), cb.getContentHeight(), rawObject)) {
                this.result = true;
            }
        }
        catch (ContentIOException e) {
            throw new ContentProcessingException(e);
        }
        catch (IOException e) {
            throw new ContentProcessingException(e);
        }
    }

    protected void handleShape(ReportElement element, Shape image) throws ContentProcessingException {
        boolean keepAr = element.getComputedStyle().getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
        this.handleImage(element, new ShapeDrawable(image, keepAr));
    }
}

