/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.build.RichTextStyleResolver;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class FastTextExtractor {
    private final StringBuilder textBuffer = new StringBuilder();
    private ExpressionRuntime runtime;
    private Object rawResult;
    private int inlineLayout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compute(ReportElement content, ExpressionRuntime runtime) throws ContentProcessingException {
        this.runtime = runtime;
        this.rawResult = null;
        this.textBuffer.delete(0, this.textBuffer.length());
        this.inlineLayout = 0;
        try {
            if (content instanceof Section) {
                this.traverseSection((Section)content);
            } else {
                this.inspectElement(content, true);
            }
            if (this.rawResult != null) {
                Object object = this.rawResult;
                return object;
            }
            String string = this.textBuffer.toString();
            return string;
        }
        finally {
            this.runtime = null;
        }
    }

    public void setRuntime(ExpressionRuntime runtime) {
        this.runtime = runtime;
    }

    protected void clearText() {
        this.textBuffer.delete(0, this.textBuffer.length());
    }

    public Object getRawResult() {
        return this.rawResult;
    }

    public String getText() {
        return this.textBuffer.toString();
    }

    protected void traverseSection(Section section) throws ContentProcessingException {
        boolean inlineSection;
        if (this.inlineLayout == 0) {
            SimpleStyleSheet styleSheet = section.getComputedStyle();
            if ("inline".equals(styleSheet.getStyleProperty(BandStyleKeys.LAYOUT))) {
                ++this.inlineLayout;
                inlineSection = true;
            } else {
                inlineSection = false;
            }
        } else {
            ++this.inlineLayout;
            inlineSection = true;
        }
        if (this.inspectStartSection(section, inlineSection)) {
            int count = section.getElementCount();
            for (int i = 0; i < count; ++i) {
                Element element = section.getElement(i);
                if (element instanceof SubReport) {
                    this.inspectStartSection(element, inlineSection);
                    this.inspectElement(element, inlineSection);
                    this.inspectEndSection(element, inlineSection);
                    continue;
                }
                if (element instanceof Section) {
                    this.traverseSection((Section)element);
                    continue;
                }
                this.inspectStartSection(element, inlineSection);
                this.inspectElement(element, inlineSection);
                this.inspectEndSection(element, inlineSection);
            }
        }
        this.inspectEndSection(section, inlineSection);
        if (this.inlineLayout > 0) {
            --this.inlineLayout;
        }
    }

    protected void inspectEndSection(ReportElement section, boolean inlineSection) {
    }

    protected boolean inspectStartSection(ReportElement section, boolean inlineSection) {
        return false;
    }

    protected void inspectElement(ReportElement element, boolean inlineSection) throws ContentProcessingException {
        if (element instanceof Section) {
            return;
        }
        Object value = AbstractFormattedDataBuilder.filterRichText(element, element.getElementType().getValue(this.runtime, element));
        if (value == null) {
            return;
        }
        if (value instanceof Section) {
            Section section = (Section)value;
            RichTextStyleResolver.resolveStyle(section);
            this.traverseSection(section);
            return;
        }
        this.handleValueContent(element, value, inlineSection);
    }

    protected void handleValueContent(ReportElement element, Object value, boolean inlineSection) throws ContentProcessingException {
        if (value instanceof String) {
            this.textBuffer.append(value);
            ElementType dataSource = element.getElementType();
            if (dataSource instanceof RawDataSource) {
                RawDataSource rds = (RawDataSource)((Object)dataSource);
                this.rawResult = rds.getRawValue(this.runtime, element);
            } else {
                this.rawResult = null;
            }
            return;
        }
        this.rawResult = value;
    }

    protected StringBuilder getTextBuffer() {
        return this.textBuffer;
    }

    protected void setRawResult(Object rawResult) {
        this.rawResult = rawResult;
    }

    protected int getTextLength() {
        return this.textBuffer.length();
    }
}

