/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.FastExportOutputFunction;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelExportTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class FastExcelExportProcessor
extends AbstractReportProcessor {
    private OutputStream outputStream;
    private boolean useXlsx;

    public FastExcelExportProcessor(MasterReport report, OutputStream outputStream, boolean useXlsx) throws ReportProcessingException {
        super(report, new ExcelDataOutputProcessor());
        this.outputStream = outputStream;
        this.useXlsx = useXlsx;
    }

    @Override
    protected OutputFunction createLayoutManager() {
        return new FastExportOutputFunction(new FastExcelExportTemplate(this.outputStream, this.useXlsx));
    }

    private static class ExcelDataOutputProcessor
    extends AbstractOutputProcessor {
        private OutputProcessorMetaData metaData = new ExcelOutputProcessorMetaData(0){

            @Override
            public void initialize(Configuration configuration) {
                super.initialize(configuration);
                this.addFeature(OutputProcessorFeature.FAST_EXPORT);
            }
        };

        private ExcelDataOutputProcessor() {
        }

        @Override
        protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        }

        @Override
        public OutputProcessorMetaData getMetaData() {
            return this.metaData;
        }
    }
}

