/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class BorderRenderer {
    private static final AffineTransform scaleInstance;
    private boolean sameForAllSides;
    private Color backgroundColor;
    private Shape borderShape;
    private Shape borderShapeTop;
    private Shape borderShapeLeft;
    private Shape borderShapeBottom;
    private Shape borderShapeRight;
    private Arc2D reusableArc = new Arc2D.Double();
    private BoxDefinition boxDefinition;
    private long x;
    private long y;
    private long width;
    private long height;
    private StaticBoxLayoutProperties staticBoxLayoutProperties;

    private void initialize(RenderBox box) {
        this.initialize(box.getStaticBoxLayoutProperties(), box.getBoxDefinition(), box.getStyleSheet(), box.getX(), box.getY(), box.getWidth(), box.getHeight());
    }

    private void initialize(StaticBoxLayoutProperties staticBoxLayoutProperties, BoxDefinition boxDefinition, StyleSheet styleSheet, long x, long y, long width, long height) {
        this.staticBoxLayoutProperties = staticBoxLayoutProperties;
        this.boxDefinition = boxDefinition;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.sameForAllSides = boxDefinition.getBorder().isSameForAllSides();
        this.backgroundColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        this.borderShape = null;
        this.borderShapeTop = null;
        this.borderShapeLeft = null;
        this.borderShapeBottom = null;
        this.borderShapeRight = null;
    }

    private BasicStroke createStroke(BorderEdge edge, long internalWidth) {
        float effectiveWidth = (float)StrictGeomUtility.toExternalValue(internalWidth);
        if (BorderStyle.HIDDEN.equals(edge.getBorderStyle())) {
            return null;
        }
        if (BorderStyle.DASHED.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{6.0f * effectiveWidth, 6.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOTTED.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 5.0f, new float[]{0.0f, 2.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOT_DASH.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
        }
        if (BorderStyle.DOT_DOT_DASH.equals(edge.getBorderStyle())) {
            return new BasicStroke(effectiveWidth, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
        }
        return new BasicStroke(effectiveWidth, 0, 0);
    }

    public void paintBackgroundAndBorder(RenderBox box, Graphics2D g2d) {
        this.initialize(box);
        this.paint(g2d);
    }

    public void paintBackgroundAndBorder(StaticBoxLayoutProperties staticBoxLayoutProperties, BoxDefinition boxDefinition, StyleSheet styleSheet, long x, long y, long width, long height, Graphics2D g2d) {
        this.initialize(staticBoxLayoutProperties, boxDefinition, styleSheet, x, y, width, height);
        this.paint(g2d);
    }

    private void paint(Graphics2D g2d) {
        BorderEdge borderEdge;
        BasicStroke basicStroke;
        StaticBoxLayoutProperties sblp;
        Border border = this.boxDefinition.getBorder();
        if (this.backgroundColor == null && border.isEmpty()) {
            return;
        }
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        if (this.isSameForAllSides()) {
            BorderEdge borderEdge2;
            BasicStroke basicStroke2;
            Shape borderShape = this.getBorderShape();
            if (this.backgroundColor != null) {
                g2d.setColor(this.backgroundColor);
                g2d.fill(borderShape);
            }
            if (this.staticBoxLayoutProperties.getBorderTop() > 0L && (basicStroke2 = this.createStroke(borderEdge2 = border.getTop(), this.staticBoxLayoutProperties.getBorderTop())) != null) {
                g2d.setColor(borderEdge2.getColor());
                g2d.setStroke(basicStroke2);
                g2d.draw(borderShape);
            }
            g2d.setColor(oldColor);
            g2d.setStroke(oldStroke);
            return;
        }
        if (this.backgroundColor != null) {
            Shape borderShape = this.getBorderShape();
            g2d.setColor(this.backgroundColor);
            g2d.fill(borderShape);
        }
        if ((sblp = this.staticBoxLayoutProperties).getBorderTop() > 0L && (basicStroke = this.createStroke(borderEdge = border.getTop(), this.staticBoxLayoutProperties.getBorderTop())) != null) {
            g2d.setColor(borderEdge.getColor());
            g2d.setStroke(basicStroke);
            g2d.draw(this.getBorderTopShape());
        }
        if (sblp.getBorderRight() > 0L && (basicStroke = this.createStroke(borderEdge = border.getRight(), this.staticBoxLayoutProperties.getBorderRight())) != null) {
            g2d.setColor(borderEdge.getColor());
            g2d.setStroke(basicStroke);
            g2d.draw(this.getBorderRightShape());
        }
        if (sblp.getBorderBottom() > 0L && (basicStroke = this.createStroke(borderEdge = border.getBottom(), this.staticBoxLayoutProperties.getBorderBottom())) != null) {
            g2d.setColor(borderEdge.getColor());
            g2d.setStroke(basicStroke);
            g2d.draw(this.getBorderBottomShape());
        }
        if (sblp.getBorderLeft() > 0L && (basicStroke = this.createStroke(borderEdge = border.getLeft(), this.staticBoxLayoutProperties.getBorderLeft())) != null) {
            g2d.setColor(borderEdge.getColor());
            g2d.setStroke(basicStroke);
            g2d.draw(this.getBorderLeftShape());
        }
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    private boolean isSameForAllSides() {
        return this.sameForAllSides;
    }

    private Arc2D configureArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        this.reusableArc.setArc(x, y, w, h, angSt, angExt, closure);
        return this.reusableArc;
    }

    public Shape getBorderShape() {
        long bottomRightHeight;
        long bottomRightWidth;
        long bottomLeftHeight;
        long bottomLeftWidth;
        long topRightHeight;
        long topRightWidth;
        if (this.borderShape != null) {
            return this.borderShape;
        }
        StaticBoxLayoutProperties sblp = this.staticBoxLayoutProperties;
        long x = this.x + sblp.getBorderLeft() / 2L;
        long y = this.y + sblp.getBorderTop() / 2L;
        long w = this.width - (sblp.getBorderLeft() + sblp.getBorderRight()) / 2L;
        long h = this.height - (sblp.getBorderTop() + sblp.getBorderBottom()) / 2L;
        Border border = this.boxDefinition.getBorder();
        long topLeftWidth = border.getTopLeft().getWidth();
        long topLeftHeight = border.getTopLeft().getHeight();
        if (this.isSameForAllSides()) {
            topRightWidth = topLeftWidth;
            topRightHeight = topLeftHeight;
            bottomLeftWidth = topLeftWidth;
            bottomLeftHeight = topLeftHeight;
            bottomRightWidth = topLeftWidth;
            bottomRightHeight = topLeftHeight;
        } else {
            topRightWidth = border.getTopRight().getWidth();
            topRightHeight = border.getTopRight().getHeight();
            bottomLeftWidth = border.getBottomLeft().getWidth();
            bottomLeftHeight = border.getBottomLeft().getHeight();
            bottomRightWidth = border.getBottomRight().getWidth();
            bottomRightHeight = border.getBottomRight().getHeight();
        }
        if (topLeftHeight == 0L && topRightHeight == 0L && topLeftWidth == 0L && topRightWidth == 0L && bottomLeftHeight == 0L && bottomRightHeight == 0L && bottomLeftWidth == 0L && bottomRightWidth == 0L) {
            this.borderShape = new Rectangle2D.Double(StrictGeomUtility.toExternalValue(x), StrictGeomUtility.toExternalValue(y), StrictGeomUtility.toExternalValue(w), StrictGeomUtility.toExternalValue(h));
            return this.borderShape;
        }
        GeneralPath generalPath = new GeneralPath(1, 200);
        generalPath.append(this.configureArc(x, y, 2L * topLeftWidth, 2L * topLeftHeight, -225.0, -45.0, 0), true);
        generalPath.lineTo(x + w - topRightWidth, y);
        generalPath.append(this.configureArc(x + w - 2L * topRightWidth, y, 2L * topRightWidth, 2L * topRightHeight, 90.0, -45.0, 0), true);
        generalPath.append(this.configureArc(x + w - 2L * topRightWidth, y, 2L * topRightWidth, 2L * topRightHeight, 45.0, -45.0, 0), true);
        generalPath.lineTo(x + w, y + h - bottomRightHeight);
        generalPath.append(this.configureArc(x + w - 2L * bottomRightWidth, y + h - 2L * bottomRightHeight, 2L * bottomRightWidth, 2L * bottomRightHeight, 0.0, -45.0, 0), true);
        generalPath.append(this.configureArc(x + w - 2L * bottomRightWidth, y + h - 2L * bottomRightHeight, 2L * bottomRightWidth, 2L * bottomRightHeight, -45.0, -45.0, 0), true);
        generalPath.lineTo(x + bottomLeftWidth, y + h);
        generalPath.append(this.configureArc(x, y + h - 2L * bottomLeftHeight, 2L * bottomLeftWidth, 2L * bottomLeftHeight, -90.0, -45.0, 0), true);
        generalPath.append(this.configureArc(x, y + h - 2L * bottomLeftHeight, 2L * bottomLeftWidth, 2L * bottomLeftHeight, -135.0, -45.0, 0), true);
        generalPath.lineTo(x, y + topLeftHeight);
        generalPath.append(this.configureArc(x, y, 2L * topLeftWidth, 2L * topLeftHeight, -180.0, -45.0, 0), true);
        generalPath.closePath();
        generalPath.transform(scaleInstance);
        this.borderShape = generalPath;
        return generalPath;
    }

    public Shape getBorderTopShape() {
        if (this.borderShapeTop != null) {
            return this.borderShapeTop;
        }
        StaticBoxLayoutProperties sblp = this.staticBoxLayoutProperties;
        long halfBorderWidth = sblp.getBorderTop() / 2L;
        long x = this.x;
        long y = this.y + halfBorderWidth;
        long w = this.width;
        Border border = this.boxDefinition.getBorder();
        long topLeftWidth = border.getTopLeft().getWidth();
        long topLeftHeight = border.getTopLeft().getHeight();
        long topRightWidth = border.getTopRight().getWidth();
        long topRightHeight = border.getTopRight().getHeight();
        if (topLeftWidth == 0L && topRightWidth == 0L && topLeftHeight == 0L && topRightHeight == 0L) {
            double lineX1 = StrictGeomUtility.toExternalValue(x);
            double lineX2 = StrictGeomUtility.toExternalValue(x + w);
            double lineY = StrictGeomUtility.toExternalValue(y);
            this.borderShapeTop = new Line2D.Double(lineX1, lineY, lineX2, lineY);
            return this.borderShapeTop;
        }
        GeneralPath generalPath = new GeneralPath(1, 20);
        generalPath.append(this.configureArc(x, y, 2L * topLeftWidth, 2L * topLeftHeight, -225.0, -45.0, 0), true);
        generalPath.lineTo(x + w - topRightWidth, y);
        generalPath.append(this.configureArc(x + w - 2L * topRightWidth, y, 2L * topRightWidth, 2L * topRightHeight, 90.0, -45.0, 0), true);
        generalPath.transform(scaleInstance);
        this.borderShapeTop = generalPath;
        return generalPath;
    }

    public Shape getBorderBottomShape() {
        if (this.borderShapeBottom != null) {
            return this.borderShapeBottom;
        }
        StaticBoxLayoutProperties sblp = this.staticBoxLayoutProperties;
        long halfBorderWidth = sblp.getBorderBottom() / 2L;
        long x = this.x;
        long y = this.y;
        long w = this.width;
        long h = this.height;
        Border border = this.boxDefinition.getBorder();
        long bottomLeftWidth = border.getBottomLeft().getWidth();
        long bottomLeftHeight = border.getBottomLeft().getHeight();
        long bottomRightWidth = border.getBottomRight().getWidth();
        long bottomRightHeight = border.getBottomRight().getHeight();
        if (bottomLeftWidth == 0L && bottomRightWidth == 0L && bottomLeftHeight == 0L && bottomRightHeight == 0L) {
            double lineX1 = StrictGeomUtility.toExternalValue(x);
            double lineX2 = StrictGeomUtility.toExternalValue(x + w);
            double lineY = StrictGeomUtility.toExternalValue(y + h - halfBorderWidth);
            this.borderShapeBottom = new Line2D.Double(lineX1, lineY, lineX2, lineY);
            return this.borderShapeBottom;
        }
        GeneralPath generalPath = new GeneralPath(1, 20);
        generalPath.append(this.configureArc(x + w - 2L * bottomRightWidth, y + h - 2L * bottomRightHeight, 2L * bottomRightWidth, 2L * bottomRightHeight, -45.0, -45.0, 0), true);
        generalPath.lineTo(x + bottomLeftWidth, y + h);
        generalPath.append(this.configureArc(x, y + h - 2L * bottomLeftHeight, 2L * bottomLeftWidth, 2L * bottomLeftHeight, -90.0, -45.0, 0), true);
        generalPath.transform(scaleInstance);
        this.borderShapeBottom = generalPath;
        return generalPath;
    }

    public Shape getBorderLeftShape() {
        if (this.borderShapeLeft != null) {
            return this.borderShapeLeft;
        }
        StaticBoxLayoutProperties sblp = this.staticBoxLayoutProperties;
        long halfBorderWidth = sblp.getBorderLeft() / 2L;
        long x = this.x;
        long y = this.y;
        long h = this.height;
        Border border = this.boxDefinition.getBorder();
        long topLeftWidth = border.getTopLeft().getWidth();
        long topLeftHeight = border.getTopLeft().getHeight();
        long bottomLeftWidth = border.getBottomLeft().getWidth();
        long bottomLeftHeight = border.getBottomLeft().getHeight();
        if (bottomLeftWidth == 0L && topLeftWidth == 0L && bottomLeftHeight == 0L && topLeftHeight == 0L) {
            double lineX = StrictGeomUtility.toExternalValue(x + halfBorderWidth);
            double lineY1 = StrictGeomUtility.toExternalValue(y);
            double lineY2 = StrictGeomUtility.toExternalValue(y + h);
            this.borderShapeLeft = new Line2D.Double(lineX, lineY1, lineX, lineY2);
            return this.borderShapeLeft;
        }
        GeneralPath generalPath = new GeneralPath(1, 20);
        generalPath.append(this.configureArc(x, y + h - 2L * bottomLeftHeight, 2L * bottomLeftWidth, 2L * bottomLeftHeight, -135.0, -45.0, 0), true);
        generalPath.lineTo(x, y + topLeftHeight);
        generalPath.append(this.configureArc(x, y, 2L * topLeftWidth, 2L * topLeftHeight, -180.0, -45.0, 0), true);
        generalPath.transform(scaleInstance);
        this.borderShapeLeft = generalPath;
        return generalPath;
    }

    public Shape getBorderRightShape() {
        if (this.borderShapeRight != null) {
            return this.borderShapeRight;
        }
        StaticBoxLayoutProperties sblp = this.staticBoxLayoutProperties;
        long halfBorderWidth = sblp.getBorderRight() / 2L;
        long x = this.x;
        long y = this.y;
        long w = this.width;
        long h = this.height;
        Border border = this.boxDefinition.getBorder();
        long topRightWidth = border.getTopRight().getWidth();
        long topRightHeight = border.getTopRight().getHeight();
        long bottomRightWidth = border.getBottomRight().getWidth();
        long bottomRightHeight = border.getBottomRight().getHeight();
        if (topRightWidth == 0L && bottomRightWidth == 0L && topRightHeight == 0L && bottomRightHeight == 0L) {
            double lineX = StrictGeomUtility.toExternalValue(x + w - halfBorderWidth);
            double lineY1 = StrictGeomUtility.toExternalValue(y);
            double lineY2 = StrictGeomUtility.toExternalValue(y + h);
            this.borderShapeRight = new Line2D.Double(lineX, lineY1, lineX, lineY2);
            return this.borderShapeRight;
        }
        GeneralPath generalPath = new GeneralPath(1, 20);
        generalPath.append(this.configureArc(x + w - 2L * topRightWidth, y, 2L * topRightWidth, 2L * topRightHeight, 45.0, -45.0, 0), true);
        generalPath.lineTo(x + w, y + h - bottomRightHeight);
        generalPath.append(this.configureArc(x + w - 2L * bottomRightWidth, y + h - 2L * bottomRightHeight, 2L * bottomRightWidth, 2L * bottomRightHeight, 0.0, -45.0, 0), true);
        generalPath.transform(scaleInstance);
        this.borderShapeRight = generalPath;
        return generalPath;
    }

    static {
        long conversionFactor = StrictGeomUtility.toInternalValue(1.0);
        scaleInstance = AffineTransform.getScaleInstance(1.0 / (double)conversionFactor, 1.0 / (double)conversionFactor);
    }
}

