/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AbstractPageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AllPageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfDocumentWriter;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.support.itext.BaseFontModule;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontStorage;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PdfOutputProcessor
extends AbstractPageableOutputProcessor {
    private PdfOutputProcessorMetaData metaData;
    private PageFlowSelector flowSelector;
    private OutputStream outputStream;
    private PdfDocumentWriter writer;
    private ResourceManager resourceManager;

    public PdfOutputProcessor(Configuration configuration, OutputStream outputStream) {
        this(configuration, outputStream, PdfOutputProcessor.createResourceManager());
    }

    private static ResourceManager createResourceManager() {
        return new ResourceManager();
    }

    public PdfOutputProcessor(Configuration configuration, OutputStream outputStream, ResourceManager resourceManager) {
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("OutputStream must not be null");
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.outputStream = outputStream;
        this.flowSelector = new AllPageFlowSelector();
        ITextFontStorage fontStorage = new ITextFontStorage(BaseFontModule.getFontRegistry());
        this.metaData = new PdfOutputProcessorMetaData(fontStorage);
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public PageFlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(PageFlowSelector flowSelector) {
        if (flowSelector == null) {
            throw new NullPointerException();
        }
        this.flowSelector = flowSelector;
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
            this.metaData.commit();
        }
    }

    @Override
    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                this.writer = this.createPdfDocumentWriter();
                this.writer.open();
            }
            this.writer.processPhysicalPage(pageGrid, logicalPage, row, col, pageKey);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate PDF document", e);
        }
    }

    @Override
    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws ContentProcessingException {
        try {
            if (this.writer == null) {
                this.writer = this.createPdfDocumentWriter();
                this.writer.open();
            }
            this.writer.processLogicalPage(key, logicalPage);
        }
        catch (Exception e) {
            throw new ContentProcessingException("Failed to generate PDF document", e);
        }
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected PdfDocumentWriter getWriter() {
        return this.writer;
    }

    protected PdfDocumentWriter createPdfDocumentWriter() {
        return new PdfDocumentWriter((PdfOutputProcessorMetaData)this.getMetaData(), this.getOutputStream(), this.getResourceManager());
    }
}

