/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.DefaultPrinterSpecification;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterEncoding;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;

public class PropertyPrinterSpecificationLoader {
    public static final String ENCODING_PREFIX = "encoding.";
    public static final String ENCODING_NAME = ".name";
    public static final String ENCODING_CHARSET = ".charset";
    public static final String ENCODING_BYTES = ".bytes";
    public static final String PRINTER_PREFIX = "printer.";
    public static final String PRINTER_NAME = ".name";
    public static final String PRINTER_ENCODINGS = ".encodings";
    public static final String PRINTER_OPERATIONS = ".operations";

    public PrinterSpecification[] loadPrinters(DefaultConfiguration printerConfig, PrinterEncoding[] encodings) {
        if (encodings == null) {
            throw new NullPointerException();
        }
        if (printerConfig == null) {
            throw new NullPointerException();
        }
        HashMap<String, PrinterEncoding> encodingsByKey = new HashMap<String, PrinterEncoding>();
        for (int i = 0; i < encodings.length; ++i) {
            encodingsByKey.put(encodings[i].getInternalName(), encodings[i]);
        }
        HashSet<String> availablePrinterNames = new HashSet<String>();
        Iterator it = printerConfig.findPropertyKeys(PRINTER_PREFIX);
        while (it.hasNext()) {
            int endIndex;
            String name = (String)it.next();
            int beginIndex = name.indexOf(46);
            if (beginIndex == -1 || (endIndex = name.indexOf(46, beginIndex + 1)) == -1) continue;
            availablePrinterNames.add(name.substring(beginIndex + 1, endIndex));
        }
        PrinterSpecification[] retval = new PrinterSpecification[availablePrinterNames.size()];
        int index = 0;
        for (String printerKey : availablePrinterNames) {
            String printerName = printerConfig.getProperty(PRINTER_PREFIX + printerKey + ".name");
            String printerCharsets = printerConfig.getProperty(PRINTER_PREFIX + printerKey + PRINTER_ENCODINGS);
            String[] supportedCharsets = this.parseCSVString(printerCharsets);
            DefaultPrinterSpecification specification = this.createPrinterSpecification(printerKey, printerName);
            for (int i = 0; i < supportedCharsets.length; ++i) {
                PrinterEncoding encoding = (PrinterEncoding)encodingsByKey.get(supportedCharsets[i]);
                if (encoding == null) {
                    throw new NullPointerException("PrinterEncoding '" + supportedCharsets[i] + "' is not defined.");
                }
                specification.addEncoding(encoding);
            }
            retval[index] = specification;
            ++index;
        }
        return retval;
    }

    protected DefaultPrinterSpecification createPrinterSpecification(String name, String displayName) {
        if (displayName == null) {
            return new DefaultPrinterSpecification(name, name);
        }
        return new DefaultPrinterSpecification(name, displayName);
    }

    protected PrinterEncoding[] loadEncodings(DefaultConfiguration encodingConfig) {
        HashSet<String> availableEncodingNames = new HashSet<String>();
        Iterator it = encodingConfig.findPropertyKeys(ENCODING_PREFIX);
        while (it.hasNext()) {
            int endIndex;
            String name = (String)it.next();
            int beginIndex = name.indexOf(46);
            if (beginIndex == -1 || (endIndex = name.indexOf(46, beginIndex + 1)) == -1) continue;
            availableEncodingNames.add(name.substring(beginIndex + 1, endIndex));
        }
        Iterator encIt = availableEncodingNames.iterator();
        ArrayList<PrinterEncoding> encodings = new ArrayList<PrinterEncoding>();
        while (encIt.hasNext()) {
            String encodingKey = (String)encIt.next();
            String encodingName = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ".name");
            String encodingCharset = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ENCODING_CHARSET);
            String encodingBytes = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ENCODING_BYTES);
            byte[] encodingCode = this.parseBytes(encodingBytes);
            PrinterEncoding encoding = new PrinterEncoding(encodingKey, encodingName, encodingCharset, encodingCode);
            encodings.add(encoding);
        }
        return encodings.toArray(new PrinterEncoding[encodings.size()]);
    }

    private byte[] parseBytes(String encString) {
        StringTokenizer strtok = new StringTokenizer(encString, ",", false);
        ArrayList<String> tokens = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            tokens.add(token);
        }
        byte[] retval = new byte[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            retval[i] = Byte.parseByte((String)tokens.get(i));
        }
        return retval;
    }

    private String[] parseCSVString(String encString) {
        StringTokenizer strtok = new StringTokenizer(encString, ",", false);
        ArrayList<String> tokens = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            tokens.add(token);
        }
        String[] retval = new String[tokens.size()];
        return tokens.toArray(retval);
    }
}

