/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.support.itext;

import com.lowagie.text.pdf.BaseFont;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class BaseFontResourceFactory
implements ResourceFactory {
    public static final FactoryParameterKey FONTNAME = new FactoryParameterKey("filename");
    public static final FactoryParameterKey ENCODING = new FactoryParameterKey("encoding");
    public static final FactoryParameterKey EMBEDDED = new FactoryParameterKey("embedded");

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        ResourceKey key = data.getKey();
        Map factoryParameters = key.getFactoryParameters();
        boolean embedded = Boolean.TRUE.equals(factoryParameters.get(EMBEDDED));
        String encoding = String.valueOf(factoryParameters.get(ENCODING));
        String fontType = String.valueOf(factoryParameters.get(FONTNAME));
        DependencyCollector dc = new DependencyCollector(key, data.getVersion(manager));
        byte[] ttfAfm = data.getResource(manager);
        byte[] pfb = null;
        if (embedded && (fontType.endsWith(".afm") || fontType.endsWith(".pfm"))) {
            String pfbFileName = fontType.substring(0, fontType.length() - 4) + ".pfb";
            try {
                ResourceKey pfbKey = manager.deriveKey(key, pfbFileName);
                ResourceData res = manager.load(pfbKey);
                pfb = res.getResource(manager);
                dc.add(pfbKey, res.getVersion(manager));
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        try {
            BaseFont baseFont = BaseFont.createFont((String)fontType, (String)encoding, (boolean)embedded, (boolean)false, (byte[])ttfAfm, pfb);
            return new CompoundResource(key, dc, (Object)baseFont, this.getFactoryType());
        }
        catch (Exception e) {
            throw new ResourceCreationException("Failed to create the font " + fontType, e);
        }
    }

    public Class getFactoryType() {
        return BaseFont.class;
    }

    public void initializeDefaults() {
    }
}

