/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StreamRTFOutputProcessor;

public final class RTFReportUtil {
    private RTFReportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRTF(MasterReport report, String filename) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        try {
            RTFReportUtil.createRTF(report, fout);
            ((OutputStream)fout).close();
            fout = null;
        }
        finally {
            if (fout != null) {
                try {
                    ((OutputStream)fout).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void createRTF(MasterReport report, OutputStream outputStream) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        StreamRTFOutputProcessor target = new StreamRTFOutputProcessor(report.getConfiguration(), outputStream, report.getResourceManager());
        StreamReportProcessor proc = new StreamReportProcessor(report, target);
        proc.processReport();
        proc.close();
    }
}

