/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.CachingExcelColorSupport;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.CellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.DynamicExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelImageHandler;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrintSetupFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFCellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.SheetPropertySource;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.StaticExcelColorSupport;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.XSSFExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.RotatedTextDrawable;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public abstract class ExcelPrinterBase {
    private static final Log logger = LogFactory.getLog(ExcelPrinterBase.class);
    private final HashMap<String, Integer> sheetNamesCount = new HashMap();
    private Configuration config;
    private OutputProcessorMetaData metaData;
    private double scaleFactor;
    private InputStream templateInputStream;
    private ExcelColorProducer colorProducer;
    private ExcelColorProducer fontColorProducer;
    private boolean useXlsxFormat;
    private CellStyleProducer cellStyleProducer;
    private ExcelImageHandler imageHandler;
    private Drawing patriarch;

    public boolean isUseXlsxFormat() {
        return this.useXlsxFormat;
    }

    public void setUseXlsxFormat(boolean useXlsxFormat) {
        this.useXlsxFormat = useXlsxFormat;
    }

    public boolean isInitialized() {
        return this.metaData != null;
    }

    protected void init(OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.metaData = metaData;
        this.config = metaData.getConfiguration();
        this.imageHandler = new ExcelImageHandler(resourceManager, this);
        try {
            String scaleFactorText = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.CellWidthScaleFactor");
            this.scaleFactor = scaleFactorText == null ? 50.0 : Double.parseDouble(scaleFactorText);
        }
        catch (Exception e) {
            this.scaleFactor = 50.0;
        }
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    protected String makeUnique(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Integer count = this.sheetNamesCount.get(name);
        if (count == null) {
            this.sheetNamesCount.put(name, IntegerCache.getInteger(1));
            return name;
        }
        int value = count + 1;
        this.sheetNamesCount.put(name, IntegerCache.getInteger(value));
        return this.makeUnique(name + ' ' + value);
    }

    protected boolean isValidSheetName(String sheetname) {
        return sheetname.indexOf(47) <= -1 && sheetname.indexOf(92) <= -1 && sheetname.indexOf(63) <= -1 && sheetname.indexOf(42) <= -1 && sheetname.indexOf(93) <= -1 && sheetname.indexOf(91) <= -1 && sheetname.indexOf(58) <= -1;
    }

    protected Cell getCellAt(int x, int y) {
        Row row = this.getRowAt(y);
        Cell cell = row.getCell(x);
        if (cell != null) {
            return cell;
        }
        return row.createCell(x);
    }

    protected Row getRowAt(int y) {
        Sheet sheet = this.getSheet();
        Row row = sheet.getRow(y);
        if (row != null) {
            return row;
        }
        return sheet.createRow(y);
    }

    protected abstract Sheet getSheet();

    protected boolean isHeaderFooterValid(String left, String center, String right) {
        int length = 0;
        if (left != null) {
            length += left.length();
        }
        if (center != null) {
            length += center.length();
        }
        if (right != null) {
            length += right.length();
        }
        return length < 255;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public CellStyleProducer getCellStyleProducer() {
        return this.cellStyleProducer;
    }

    protected Workbook createWorkbook() {
        if (this.templateInputStream != null) {
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)this.templateInputStream);
                int sheetCount = workbook.getNumberOfSheets();
                for (int i = 0; i < sheetCount; ++i) {
                    String sheetName = workbook.getSheetName(i);
                    this.makeUnique(sheetName);
                }
                return workbook;
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to read predefined xls-data.", (Throwable)e);
            }
            catch (InvalidFormatException e) {
                logger.warn((Object)"Unable to read predefined xls-data.", (Throwable)e);
            }
        }
        if (this.isUseXlsxFormat()) {
            return new XSSFWorkbook();
        }
        return new HSSFWorkbook();
    }

    protected void initializeStyleProducers(Workbook workbook) {
        if (workbook instanceof HSSFWorkbook) {
            boolean dynamicColors = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.DynamicColors"));
            if (dynamicColors) {
                HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
                this.colorProducer = new CachingExcelColorSupport(new DynamicExcelColorProducer(hssfWorkbook));
            } else {
                this.colorProducer = new CachingExcelColorSupport(new StaticExcelColorSupport());
            }
            this.fontColorProducer = this.colorProducer;
        } else {
            this.colorProducer = new XSSFExcelColorProducer();
            this.fontColorProducer = new CachingExcelColorSupport(new StaticExcelColorSupport());
        }
        this.cellStyleProducer = this.createCellStyleProducer(workbook);
    }

    protected CellStyleProducer createCellStyleProducer(Workbook workbook) {
        boolean hardLimit = "true".equals(this.getConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.HardStyleCountLimit"));
        return new HSSFCellStyleProducer(workbook, hardLimit, this.colorProducer, this.fontColorProducer);
    }

    protected Sheet openSheet(String sheetName) {
        this.patriarch = null;
        Workbook workbook = this.getWorkbook();
        if (sheetName == null) {
            return workbook.createSheet();
        }
        String uniqueSheetname = this.makeUnique(sheetName);
        if (uniqueSheetname.length() == 0 || uniqueSheetname.length() > 31) {
            logger.warn((Object)"A sheet name must not be empty and greater than 31 characters");
            return workbook.createSheet();
        }
        if (!this.isValidSheetName(uniqueSheetname)) {
            logger.warn((Object)"A sheet name must not contain any of ':/\\*?[]'");
            return workbook.createSheet();
        }
        return workbook.createSheet(uniqueSheetname);
    }

    protected void configureSheetProperties(Sheet sheet, SheetPropertySource excelTableContentProducer) {
        String pageHeaderCenter = excelTableContentProducer.getPageHeaderCenter();
        String pageFooterCenter = excelTableContentProducer.getPageFooterCenter();
        String pageHeaderLeft = excelTableContentProducer.getPageHeaderLeft();
        String pageFooterLeft = excelTableContentProducer.getPageFooterLeft();
        String pageHeaderRight = excelTableContentProducer.getPageHeaderRight();
        String pageFooterRight = excelTableContentProducer.getPageFooterRight();
        if (this.isHeaderFooterValid(pageHeaderLeft, pageHeaderCenter, pageHeaderRight)) {
            if (pageHeaderLeft != null) {
                sheet.getHeader().setLeft(pageHeaderLeft);
            }
            if (pageHeaderCenter != null) {
                sheet.getHeader().setCenter(pageHeaderCenter);
            }
            if (pageHeaderRight != null) {
                sheet.getHeader().setRight(pageHeaderRight);
            }
        } else {
            logger.warn((Object)"Page-Header exceeds the maximum length of 255 characters. No page-header will be added to the sheet.");
        }
        if (this.isHeaderFooterValid(pageFooterLeft, pageFooterCenter, pageFooterRight)) {
            if (pageFooterCenter != null) {
                sheet.getFooter().setCenter(pageFooterCenter);
            }
            if (pageFooterLeft != null) {
                sheet.getFooter().setLeft(pageFooterLeft);
            }
            if (pageFooterRight != null) {
                sheet.getFooter().setRight(pageFooterRight);
            }
        } else {
            logger.warn((Object)"Page-Footer exceeds the maximum length of 255 characters. No page-footer will be added to the sheet.");
        }
        int sheetFreezeTop = excelTableContentProducer.getFreezeTop();
        int sheetFreezeLeft = excelTableContentProducer.getFreezeLeft();
        if (sheetFreezeTop > 0 || sheetFreezeLeft > 0) {
            sheet.createFreezePane(sheetFreezeLeft, sheetFreezeTop);
        }
    }

    protected void configureSheetPaperSize(Sheet sheet, PhysicalPageBox page) {
        Configuration config = this.getConfig();
        String paper = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.Paper");
        String orientation = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PaperOrientation");
        short scale = (short)ParserUtil.parseInt((String)config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintScaleFactor"), (int)100);
        short hres = (short)ParserUtil.parseInt((String)config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintHorizontalResolution"), (int)-1);
        short vres = (short)ParserUtil.parseInt((String)config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintVerticalResolution"), (int)-1);
        boolean noColors = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintNoColors"));
        boolean notes = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintNotes"));
        boolean usePage = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintUsePage"));
        boolean draft = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintDraft"));
        PrintSetup printSetup = sheet.getPrintSetup();
        ExcelPrintSetupFactory.performPageSetup(printSetup, page, paper, orientation);
        printSetup.setScale(scale);
        printSetup.setNoColor(noColors);
        printSetup.setNotes(notes);
        printSetup.setUsePage(usePage);
        if (hres > 0) {
            printSetup.setHResolution(hres);
        }
        if (vres > 0) {
            printSetup.setVResolution(vres);
        }
        printSetup.setDraft(draft);
        boolean displayGridLines = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.GridLinesDisplayed"));
        boolean printGridLines = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.GridLinesPrinted"));
        sheet.setDisplayGridlines(displayGridLines);
        sheet.setPrintGridlines(printGridLines);
    }

    protected void configureSheetColumnWidths(Sheet sheet, SlimSheetLayout sheetLayout, int columnCount) {
        for (int col = 0; col < columnCount; ++col) {
            double cellWidth = StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
            double poiCellWidth = cellWidth * this.getScaleFactor();
            sheet.setColumnWidth(col, Math.min(65280, (int)poiCellWidth));
        }
    }

    public abstract Workbook getWorkbook();

    protected ExcelColorProducer getColorProducer() {
        return this.colorProducer;
    }

    protected ExcelColorProducer getFontColorProducer() {
        return this.fontColorProducer;
    }

    protected Configuration getConfig() {
        return this.config;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected static String splitAndQuoteExcelFormula(String s) {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        char[] chars = s.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                b.append('\"');
                b.append('\"');
                count += 2;
            } else {
                b.append(c);
                ++count;
            }
            if (count <= 252) continue;
            count = 0;
            b.append("\" & \"");
        }
        b.append('\"');
        return b.toString();
    }

    public Drawing getDrawingPatriarch() {
        if (this.patriarch == null) {
            this.patriarch = this.getSheet().createDrawingPatriarch();
        }
        return this.patriarch;
    }

    protected void createImageCell(StyleSheet rawSource, ImageContainer imageContainer, SlimSheetLayout sheetLayout, TableRectangle rectangle, StrictBounds contentBounds) {
        this.imageHandler.createImageCell(rawSource, imageContainer, sheetLayout, rectangle, contentBounds);
    }

    protected void handleValueType(Cell cell, Object value, Workbook workbook) {
        if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            cell.setCellValue(number.doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(Boolean.TRUE.equals(value));
        } else if (RotatedTextDrawable.extract(value) != null) {
            RotatedTextDrawable rotatedTextDrawable = RotatedTextDrawable.extract(value);
            cell.setCellValue(rotatedTextDrawable.getText());
        } else if (value == null) {
            cell.setCellType(3);
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }
}

