/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelFontFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFFontWrapper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.RichTextFormat;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class ExcelTextExtractor
extends DefaultTextExtractor {
    private static final Log logger = LogFactory.getLog(ExcelTextExtractor.class);
    private ArrayList<RichTextFormat> formatBuffer;
    private FastStack<RichTextFormat> formatBufferStack;
    private ExcelColorProducer colorProducer;
    private CreationHelper creationHelper;
    private ExcelFontFactory fontFactory;

    public ExcelTextExtractor(OutputProcessorMetaData metaData, ExcelColorProducer colorProducer, CreationHelper creationHelper, ExcelFontFactory fontFactory) {
        super(metaData);
        this.creationHelper = creationHelper;
        this.fontFactory = fontFactory;
        if (colorProducer == null) {
            throw new NullPointerException();
        }
        this.colorProducer = colorProducer;
        this.formatBuffer = new ArrayList();
        this.formatBufferStack = new FastStack();
    }

    @Override
    public Object compute(RenderBox paraBox) {
        this.formatBuffer.clear();
        super.compute(paraBox);
        if (this.formatBuffer.size() <= 1) {
            Object rawResult = this.getRawResult();
            if (rawResult != null && !(rawResult instanceof String)) {
                return rawResult;
            }
            String text = this.getText();
            if (text.length() > Short.MAX_VALUE) {
                logger.warn((Object)"Excel-Cells cannot contain text larger than 32.737 characters. Text will be clipped.");
                return text.substring(0, Short.MAX_VALUE);
            }
            if (text.length() > 0) {
                return text;
            }
            return null;
        }
        String text = this.getText();
        return ExcelTextExtractor.computeRichText(this.fontFactory, this.creationHelper, text, this.formatBuffer);
    }

    public static RichTextString computeRichText(ExcelFontFactory fontFactory, CreationHelper creationHelper, String text, ArrayList<RichTextFormat> buffer) {
        if (text.length() > 0) {
            RichTextFormat o;
            int position;
            if (text.length() < 32768) {
                RichTextString rtStr = creationHelper.createRichTextString(text);
                for (int i = 0; i < buffer.size(); ++i) {
                    RichTextFormat o2 = buffer.get(i);
                    int position2 = o2.getPosition();
                    HSSFFontWrapper font = o2.getFont();
                    if (i == buffer.size() - 1) {
                        rtStr.applyFont(position2, text.length(), fontFactory.getExcelFont(font));
                        continue;
                    }
                    RichTextFormat next = buffer.get(i + 1);
                    rtStr.applyFont(position2, next.getPosition(), fontFactory.getExcelFont(font));
                }
                return rtStr;
            }
            logger.warn((Object)"Excel-Cells cannot contain text larger than 32.737 characters. Text will be clipped.");
            String realText = text.substring(0, Short.MAX_VALUE);
            RichTextString rtStr = creationHelper.createRichTextString(realText);
            for (int i = 0; i < buffer.size() && (position = (o = buffer.get(i)).getPosition()) < Short.MAX_VALUE; ++i) {
                HSSFFontWrapper font = o.getFont();
                if (i == buffer.size() - 1) {
                    int endPosition = Math.min(Short.MAX_VALUE, text.length());
                    rtStr.applyFont(position, endPosition, fontFactory.getExcelFont(font));
                    continue;
                }
                RichTextFormat next = buffer.get(i + 1);
                int endPosition = Math.min(Short.MAX_VALUE, next.getPosition());
                rtStr.applyFont(position, endPosition, fontFactory.getExcelFont(font));
            }
            return rtStr;
        }
        return null;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        StyleSheet styleSheet = box.getStyleSheet();
        Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
        HSSFFontWrapper wrapper = new HSSFFontWrapper(styleSheet, this.colorProducer.getNearestColor(textColor));
        RichTextFormat rtf = new RichTextFormat(this.getTextLength(), wrapper);
        if (this.formatBuffer.isEmpty()) {
            this.formatBuffer.add(rtf);
        } else {
            int lastIndex = this.formatBuffer.size() - 1;
            RichTextFormat lastRtf = this.formatBuffer.get(lastIndex);
            if (lastRtf.getPosition() == rtf.getPosition()) {
                this.formatBuffer.set(lastIndex, rtf);
            } else if (!lastRtf.getFont().equals(rtf.getFont())) {
                this.formatBuffer.add(rtf);
            }
        }
        this.formatBufferStack.push((Object)rtf);
        return true;
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        this.formatBufferStack.pop();
        if (this.formatBufferStack.isEmpty()) {
            return;
        }
        RichTextFormat rtf = (RichTextFormat)this.formatBufferStack.peek();
        RichTextFormat lastRtf = this.formatBuffer.get(this.formatBuffer.size() - 1);
        if (!lastRtf.getFont().equals(rtf.getFont())) {
            this.formatBuffer.add(new RichTextFormat(this.getTextLength(), rtf.getFont()));
        }
    }

    @Override
    protected void drawComplexText(RenderableComplexText renderableComplexText) {
        if (renderableComplexText.getRawText().length() == 0) {
            return;
        }
        if (!renderableComplexText.isNodeVisible(this.getParagraphBounds(), this.isOverflowX(), this.isOverflowY())) {
            return;
        }
        if (renderableComplexText.getRichText().getStyleChunks().size() > 1) {
            int relativeLength = 0;
            for (RichTextSpec.StyledChunk styledChunk : renderableComplexText.getRichText().getStyleChunks()) {
                StyleSheet styleSheet = styledChunk.getStyleSheet();
                Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
                String fontName = (String)styleSheet.getStyleProperty(TextStyleKeys.FONT);
                short fontSize = (short)styleSheet.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
                boolean bold = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD);
                boolean italic = styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC);
                boolean underline = styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
                boolean strikethrough = styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
                HSSFFontWrapper wrapper = new HSSFFontWrapper(fontName, fontSize, bold, italic, underline, strikethrough, this.colorProducer.getNearestColor(textColor));
                if (!(styledChunk.getOriginatingTextNode() instanceof RenderableComplexText)) continue;
                RichTextFormat rtf = new RichTextFormat(relativeLength, wrapper);
                relativeLength += styledChunk.getText().length();
                this.formatBuffer.add(rtf);
            }
        }
        super.drawComplexText(renderableComplexText);
    }
}

