/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.util.HSSFColor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;

public final class StaticExcelColorSupport
implements ExcelColorProducer {
    private static final Log logger = LogFactory.getLog(StaticExcelColorSupport.class);
    private static final Map triplets;
    private static final Map indexes;

    @Override
    public short getNearestColor(Color awtColor) {
        return StaticExcelColorSupport.getNearestColor(awtColor, triplets);
    }

    public static short getNearestColor(Color awtColor, Map triplets) {
        if (awtColor == null) {
            throw new NullPointerException();
        }
        if (triplets == null || triplets.isEmpty()) {
            logger.warn((Object)"Unable to get triplet hashtable");
            return 8;
        }
        short color = 8;
        double minDiff = Double.MAX_VALUE;
        float[] hsb = Color.RGBtoHSB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue(), null);
        float[] excelHsb = null;
        for (HSSFColor crtColor : triplets.values()) {
            short[] rgb = crtColor.getTriplet();
            excelHsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], excelHsb);
            double weight = 3.0 * (double)Math.min(Math.abs(excelHsb[0] - hsb[0]), Math.abs(excelHsb[0] - hsb[0] + 1.0f)) + (double)Math.abs(excelHsb[1] - hsb[1]) + (double)Math.abs(excelHsb[2] - hsb[2]);
            if (!(weight < minDiff)) continue;
            minDiff = weight;
            if (minDiff == 0.0) {
                return crtColor.getIndex();
            }
            color = crtColor.getIndex();
        }
        return color;
    }

    public HSSFColor getColor(short index) {
        Integer s = IntegerCache.getInteger(index);
        HSSFColor color = (HSSFColor)indexes.get(s);
        if (color == null) {
            throw new IllegalStateException("No such color.");
        }
        return color;
    }

    static {
        HashMap<Integer, HSSFColor.TAN> indexMap = new HashMap<Integer, HSSFColor.TAN>();
        indexMap.putAll(HSSFColor.getIndexHash());
        indexMap.put(new Integer(47), new HSSFColor.TAN());
        HashMap<String, HSSFColor.TAN> tripletMap = new HashMap<String, HSSFColor.TAN>();
        tripletMap.putAll(HSSFColor.getTripletHash());
        tripletMap.put("FFFF:CCCC:9999", new HSSFColor.TAN());
        indexes = Collections.unmodifiableMap(indexMap);
        triplets = Collections.unmodifiableMap(tripletMap);
    }
}

