/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.UserDefinedExpressionPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ExpressionMapPropertyReadHandler
extends PropertyStringReadHandler
implements UserDefinedExpressionPropertyReadHandler {
    private BeanUtility expression;
    private String originalExpressionClass;
    private String expressionClass;
    private String expressionName;
    private List<ExpressionReadHandler> expressionHandlers;
    private String propertyName;

    @Override
    public void init(BeanUtility expression, String originalExpressionClass, String expressionClass, String expressionName) {
        this.expression = expression;
        this.originalExpressionClass = originalExpressionClass;
        this.expressionClass = expressionClass;
        this.expressionName = expressionName;
        this.expressionHandlers = new ArrayList<ExpressionReadHandler>();
    }

    @Override
    public void startParsing(PropertyAttributes attrs) throws SAXException {
        this.propertyName = attrs.getValue(this.getUri(), "name");
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if ("expression".equals(tagName)) {
            ExpressionReadHandler readHandler = new ExpressionReadHandler();
            this.expressionHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    @Override
    public void doneParsing() throws SAXException {
        try {
            LinkedHashMap<String, Expression> map = new LinkedHashMap<String, Expression>();
            for (ExpressionReadHandler handler : this.expressionHandlers) {
                String name;
                Expression object = handler.getObject();
                if (object == null || (name = object.getName()) == null) continue;
                object.setName(null);
                map.put(name, object);
            }
            this.expression.setProperty(this.propertyName, map);
        }
        catch (BeanException e) {
            throw new ParseException("Unable to set property", (Exception)e, this.getLocator());
        }
    }
}

