/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class DataDefinition {
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private ReportParameterDefinition parameterDefinition;
    private DataFactory primaryDataFactory;
    private Expression[] expressions;
    private String query;
    private int queryLimit;
    private int queryTimeout;

    public DataDefinition(ReportParameterDefinition parameterDefinition, DataFactory primaryDataFactory, String query, int queryLimit, int queryTimeout, Expression[] expressions) {
        this.parameterDefinition = parameterDefinition;
        this.primaryDataFactory = primaryDataFactory;
        this.query = query;
        this.queryLimit = queryLimit;
        this.queryTimeout = queryTimeout;
        if (expressions != null) {
            this.expressions = (Expression[])expressions.clone();
        }
    }

    public String getQuery() {
        return this.query;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public Expression[] getExpressions() {
        if (this.expressions == null) {
            return EMPTY_EXPRESSIONS;
        }
        Expression[] targetExpressions = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            targetExpressions[i] = expression.getInstance();
        }
        return targetExpressions;
    }

    public ReportParameterDefinition getParameterDefinition() {
        if (this.parameterDefinition != null) {
            return (ReportParameterDefinition)this.parameterDefinition.clone();
        }
        return null;
    }

    public DataFactory getDataFactory() throws ReportDataFactoryException {
        if (this.primaryDataFactory != null) {
            return this.primaryDataFactory.derive();
        }
        return null;
    }
}

