/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.LayoutPreprocessorReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.LayoutProcessorReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.AbstractElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabGroupReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.RelationalGroupReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.ReportFooterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.ReportHeaderReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LayoutRootElementHandler
extends AbstractElementReadHandler {
    private AbstractReportDefinition report;
    private LayoutProcessorReadHandler layoutProcessorHandler;
    private ArrayList<LayoutPreprocessorReadHandler> layoutPreprocessorHandlers = new ArrayList();
    private ReportHeaderReadHandler reportHeaderReadHandler;
    private RelationalGroupReadHandler rootGroupReadHandler;
    private ReportFooterReadHandler reportFooterReadHandler;
    private CrosstabGroupReadHandler crosstabReadHandler;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        RootXmlReadHandler rootHandler = this.getRootHandler();
        Object maybeReport = rootHandler.getHelperObject("::Report");
        if (maybeReport instanceof SubReport) {
            this.report = (SubReport)maybeReport;
        } else if (maybeReport instanceof MasterReport) {
            this.report = (MasterReport)maybeReport;
        } else {
            throw new IllegalStateException("Layout.xml cannot be parsed on its own. It needs to have a report-instance.");
        }
        this.initialize(this.report.getElementType());
        super.startParsing(attrs);
    }

    @Override
    protected Element createElement() throws ParseException {
        return this.report;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri)) {
            if ("layout-processors".equals(tagName)) {
                this.layoutProcessorHandler = new LayoutProcessorReadHandler();
                return this.layoutProcessorHandler;
            }
            if ("preprocessor".equals(tagName)) {
                LayoutPreprocessorReadHandler layoutPreprocessorHandler = new LayoutPreprocessorReadHandler();
                this.layoutPreprocessorHandlers.add(layoutPreprocessorHandler);
                return layoutPreprocessorHandler;
            }
            if ("report-header".equals(tagName)) {
                if (this.reportHeaderReadHandler == null) {
                    this.reportHeaderReadHandler = new ReportHeaderReadHandler();
                }
                return this.reportHeaderReadHandler;
            }
            if ("crosstab".equals(tagName)) {
                if (this.crosstabReadHandler == null) {
                    this.crosstabReadHandler = new CrosstabGroupReadHandler();
                }
                return this.crosstabReadHandler;
            }
            if ("group".equals(tagName)) {
                if (this.rootGroupReadHandler == null) {
                    this.rootGroupReadHandler = new RelationalGroupReadHandler();
                }
                return this.rootGroupReadHandler;
            }
            if ("report-footer".equals(tagName)) {
                if (this.reportFooterReadHandler == null) {
                    this.reportFooterReadHandler = new ReportFooterReadHandler();
                }
                return this.reportFooterReadHandler;
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    protected void doneParsing() throws SAXException {
        super.doneParsing();
        if (this.layoutProcessorHandler != null) {
            Expression[] expressions = this.layoutProcessorHandler.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                Expression expression = expressions[i];
                this.report.addExpression(expression);
            }
        }
        for (int i = 0; i < this.layoutPreprocessorHandlers.size(); ++i) {
            LayoutPreprocessorReadHandler handler = this.layoutPreprocessorHandlers.get(i);
            this.report.addPreProcessor(handler.getPreProcessor());
        }
        if (this.reportHeaderReadHandler != null) {
            this.report.setReportHeader((ReportHeader)this.reportHeaderReadHandler.getElement());
        }
        if (this.rootGroupReadHandler != null) {
            this.report.setRootGroup(this.rootGroupReadHandler.getElement());
        } else if (this.crosstabReadHandler != null) {
            this.report.setRootGroup(this.crosstabReadHandler.getElement());
        }
        if (this.reportFooterReadHandler != null) {
            this.report.setReportFooter((ReportFooter)this.reportFooterReadHandler.getElement());
        }
    }
}

