/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ClassicEngineFactoryParameters;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundleUtils;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.resourceloader.LoaderParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.raw.RawResourceLoader;

public class ResourceWriter
implements BundleWriterHandler {
    private static final Log log = LogFactory.getLog(ResourceWriter.class);

    @Override
    public int getProcessingOrder() {
        return 0;
    }

    @Override
    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        BundleUtilities.copyStickyInto((WriteableDocumentBundle)bundle, (DocumentBundle)state.getGlobalBundle());
        this.processSection(bundle, state.getMasterReport(), state.getMasterReport());
        return null;
    }

    private void processSection(WriteableDocumentBundle documentBundle, MasterReport report, Section section) throws BundleWriterException {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            int j;
            Element element = section.getElement(i);
            if (element instanceof Section) {
                this.processSection(documentBundle, report, (Section)element);
            }
            if (element instanceof RootLevelBand) {
                RootLevelBand rl = (RootLevelBand)((Object)element);
                SubReport[] reports = rl.getSubReports();
                for (j = 0; j < reports.length; ++j) {
                    SubReport subReport = reports[j];
                    this.processSection(documentBundle, report, subReport);
                }
            }
            ElementMetaData metaData = element.getMetaData();
            AttributeMetaData[] attributeDescriptions = metaData.getAttributeDescriptions();
            for (j = 0; j < attributeDescriptions.length; ++j) {
                ResourceKey resourceKey;
                ResourceKey replacementKey;
                Object attribute;
                AttributeMetaData attributeDescription = attributeDescriptions[j];
                if (!"Resource".equals(attributeDescription.getValueRole()) || !((attribute = element.getAttribute(attributeDescription.getNameSpace(), attributeDescription.getName())) instanceof ResourceKey) || (replacementKey = ResourceWriter.processResourceKeyAttribute(documentBundle, report, resourceKey = (ResourceKey)attribute)) == null) continue;
                element.setAttribute(attributeDescription.getNameSpace(), attributeDescription.getName(), replacementKey);
            }
        }
    }

    private static ResourceKey processResourceKeyAttribute(WriteableDocumentBundle documentBundle, MasterReport report, ResourceKey resourceKey) throws BundleWriterException {
        if (documentBundle.isEmbeddedKey(resourceKey)) {
            return null;
        }
        boolean embedded = ResourceWriter.isEmbeddedKey(report, resourceKey);
        DefaultMimeRegistry mimeRegistry = new DefaultMimeRegistry();
        Map factoryParameters = resourceKey.getFactoryParameters();
        if (!(embedded || "true".equals(factoryParameters.get(ClassicEngineFactoryParameters.EMBED)) || RawResourceLoader.SCHEMA_NAME.equals(resourceKey.getSchema()))) {
            return null;
        }
        try {
            String pattern;
            String mimeType = (String)factoryParameters.get(ClassicEngineFactoryParameters.MIME_TYPE);
            String originalValue = (String)factoryParameters.get(ClassicEngineFactoryParameters.ORIGINAL_VALUE);
            if (mimeType == null) {
                ResourceData resourceData = report.getResourceManager().load(resourceKey);
                Object originalMimeType = resourceData.getAttribute("content-type");
                mimeType = originalMimeType instanceof String ? (String)originalMimeType : mimeRegistry.getMimeType(originalValue);
            }
            if ((pattern = (String)factoryParameters.get(ClassicEngineFactoryParameters.PATTERN)) == null) {
                pattern = ResourceWriter.derivePatternFromPath((MimeRegistry)mimeRegistry, mimeType, resourceKey.getIdentifierAsString());
            }
            log.debug((Object)("Embedding resource : originalValue=[" + originalValue + "] pattern=[" + pattern + "] mimeType=[" + mimeType + "]"));
            HashMap<LoaderParameterKey, String> newFactoryParameters = null;
            if (originalValue != null) {
                newFactoryParameters = new HashMap<LoaderParameterKey, String>();
                newFactoryParameters.put(ClassicEngineFactoryParameters.ORIGINAL_VALUE, originalValue);
            }
            ResourceKey newResourceKey = WriteableDocumentBundleUtils.embedResource((WriteableDocumentBundle)documentBundle, (ResourceManager)report.getResourceManager(), (ResourceKey)resourceKey, (String)pattern, (String)mimeType, newFactoryParameters);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resouce Embedded: [" + newResourceKey.getIdentifierAsString() + "]"));
            }
            return newResourceKey;
        }
        catch (Exception e) {
            throw new BundleWriterException("Error embedding the resource into the document bundle: " + e.getMessage(), e);
        }
    }

    public static boolean isEmbeddedKey(MasterReport report, ResourceKey resourceKey) {
        ResourceKey contentBase = report.getContentBase();
        if (contentBase == null) {
            return false;
        }
        for (ResourceKey bundleKey = contentBase.getParent(); bundleKey != null; bundleKey = bundleKey.getParent()) {
            if (!bundleKey.equals((Object)resourceKey.getParent())) continue;
            return true;
        }
        return false;
    }

    public static String derivePatternFromPath(MimeRegistry mimeRegistry, String mimeType, String path) {
        String fileName;
        String pattern;
        if (mimeType == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            if (mimeType.startsWith("image/")) {
                return "resources/image{0}." + mimeRegistry.getSuffix(mimeType);
            }
            return "resources/data{0}." + mimeRegistry.getSuffix(mimeType);
        }
        String directory = IOUtils.getInstance().getPath(path);
        String fileNameWExt = IOUtils.getInstance().getFileName(path);
        String fileExtension = IOUtils.getInstance().getFileExtension(fileNameWExt);
        if (StringUtils.isEmpty((String)fileExtension)) {
            fileExtension = "." + mimeRegistry.getSuffix(mimeType);
        }
        pattern = (pattern = ResourceWriter.stripTrailingNumbers(fileName = IOUtils.getInstance().stripFileExtension(fileNameWExt))) == null ? (mimeType.startsWith("image/") ? "image{0}" : "data{0}") : pattern + "{0}";
        return directory + "/" + pattern + fileExtension;
    }

    private static String stripTrailingNumbers(String path) {
        for (int i = path.length() - 1; i >= 0; --i) {
            if (Character.isDigit(path.charAt(i))) continue;
            return path.substring(0, i + 1);
        }
        return null;
    }
}

