/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class TableDataFactoryWriteHandler
implements BundleDataFactoryWriterHandler {
    @Override
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        try {
            TableDataFactory tableDataFactory = (TableDataFactory)dataFactory;
            String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/inline-ds{0}.xml");
            if (fileName == null) {
                throw new IOException("Unable to generate unique name for Inline-Data-Source");
            }
            OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
            DefaultTagDescription tagDescription = new DefaultTagDescription();
            tagDescription.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", false);
            tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "data", true);
            XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
            AttributeList rootAttrs = new AttributeList();
            rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/inline/1.0");
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "inline-datasource", rootAttrs, false);
            String[] tables = tableDataFactory.getQueryNames();
            for (int i = 0; i < tables.length; ++i) {
                String tableName = tables[i];
                TableModel tableModel = tableDataFactory.queryData(tableName, null);
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "inline-table", "name", tableName, false);
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "definition", false);
                Class[] colTypes = new Class[tableModel.getColumnCount()];
                for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                    AttributeList colAttrs = new AttributeList();
                    String columnName = tableModel.getColumnName(col);
                    colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "name", StringUtils.isEmpty((String)columnName) ? "<empty-" + col + ">" : columnName);
                    Class<?> columnClass = tableModel.getColumnClass(col);
                    if (columnClass == null) {
                        colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", Object.class.getName());
                        colTypes[col] = Object.class;
                    } else {
                        colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", columnClass.getName());
                        colTypes[col] = columnClass;
                    }
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "column", colAttrs, true);
                }
                xmlWriter.writeCloseTag();
                for (int row = 0; row < tableModel.getRowCount(); ++row) {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "row", false);
                    for (int col = 0; col < tableModel.getColumnCount(); ++col) {
                        AttributeList colAttrs = new AttributeList();
                        Object value = tableModel.getValueAt(row, col);
                        if (value == null) {
                            colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "null", "true");
                            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "data", colAttrs, true);
                            continue;
                        }
                        Class<?> valueClass = value.getClass();
                        if (!ObjectUtilities.equal((Object)colTypes[col], valueClass)) {
                            colAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "type", valueClass.getName());
                        }
                        try {
                            String s = ConverterRegistry.toAttributeValue(value);
                            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/inline/1.0", "data", colAttrs, false);
                            xmlWriter.writeTextNormalized(s, true);
                            xmlWriter.writeCloseTag();
                            continue;
                        }
                        catch (BeanException e) {
                            throw new BundleWriterException("Unable to convert value at (row:" + row + ";column:" + col + ") into a string." + value.getClass());
                        }
                    }
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
            xmlWriter.close();
            return fileName;
        }
        catch (ReportDataFactoryException e) {
            throw new BundleWriterException("This should not happen in the way we use the table-factory, but hey, better safe than sorry.");
        }
    }
}

