/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sequence.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class SequenceDataFactoryWriteHandler
implements BundleDataFactoryWriterHandler {
    @Override
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        SequenceDataFactory sequenceDataFactory = (SequenceDataFactory)dataFactory;
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/sequence-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Sequence-Data-Source");
        }
        try {
            OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
            DefaultTagDescription tagDescription = new DefaultTagDescription();
            tagDescription.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", false);
            tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "property", true);
            XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
            AttributeList rootAttrs = new AttributeList();
            rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/sequence/1.0");
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "sequence-datasource", rootAttrs, false);
            String[] tables = sequenceDataFactory.getQueryNames();
            for (int i = 0; i < tables.length; ++i) {
                String queryName = tables[i];
                Sequence sequence = sequenceDataFactory.getSequence(queryName);
                AttributeList sequenceAttributes = new AttributeList();
                sequenceAttributes.setAttribute("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "name", queryName);
                sequenceAttributes.setAttribute("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "class", sequence.getClass().getName());
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "sequence", sequenceAttributes, false);
                SequenceDescription sequenceDescription = sequence.getSequenceDescription();
                int parameterCount = sequenceDescription.getParameterCount();
                for (int p = 0; p < parameterCount; ++p) {
                    String paramName = sequenceDescription.getParameterName(p);
                    Object parameter = sequence.getParameter(paramName);
                    if (parameter == null) continue;
                    String attrValue = ConverterRegistry.toAttributeValue(parameter);
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/sequence/1.0", "property", "name", paramName, false);
                    xmlWriter.writeTextNormalized(attrValue, true);
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
            xmlWriter.close();
            return fileName;
        }
        catch (BeanException e) {
            throw new BundleWriterException("Unable to serialize sequence parameter", e);
        }
    }
}

