/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.writer.ConnectionProviderWriteHandler;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DriverConnectionProviderWriteHandler
implements ConnectionProviderWriteHandler {
    @Override
    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, ConnectionProvider connectionProvider) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        DriverConnectionProvider driverProvider = (DriverConnectionProvider)connectionProvider;
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "connection", false);
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "driver", false);
        xmlWriter.writeTextNormalized(driverProvider.getDriver(), false);
        xmlWriter.writeCloseTag();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "url", false);
        xmlWriter.writeTextNormalized(driverProvider.getUrl(), false);
        xmlWriter.writeCloseTag();
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "properties", false);
        String[] propertyNames = driverProvider.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            String value = driverProvider.getProperty(name);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/sql", "property", "name", name, false);
            if (name.toLowerCase().contains("password")) {
                xmlWriter.writeTextNormalized(PasswordEncryptionService.getInstance().encrypt(value), false);
            } else {
                xmlWriter.writeTextNormalized(value, false);
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.writeCloseTag();
        return null;
    }
}

