/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class BandReadHandler
extends ElementReadHandler {
    private static final Log logger = LogFactory.getLog(BandReadHandler.class);
    private ArrayList elementHandlers = new ArrayList();
    private ArrayList styleExpressionHandlers = new ArrayList();

    public BandReadHandler(Band element) {
        super(element);
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("style".equals(tagName)) {
            return new StyleReadHandler(this.getElement().getStyle());
        }
        if ("default-style".equals(tagName)) {
            logger.warn((Object)"Tag <default-style> is deprecated. All definitions have been mapped into the bands primary style sheet.");
            return new StyleReadHandler(this.getElement().getStyle());
        }
        if ("style-expression".equals(tagName)) {
            StyleExpressionHandler styleExpressionHandler = new StyleExpressionHandler();
            this.styleExpressionHandlers.add(styleExpressionHandler);
            return styleExpressionHandler;
        }
        if ("element".equals(tagName)) {
            String type = atts.getValue(this.getUri(), "type");
            ElementFactoryCollector fc = (ElementFactoryCollector)this.getRootHandler().getHelperObject("::element-factory");
            Element element = fc.getElementForType(type);
            if (element == null) {
                throw new ParseException("There is no factory for elements of type '" + type + '\'', this.getLocator());
            }
            ElementReadHandler readHandler = new ElementReadHandler(element);
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if ("band".equals(tagName)) {
            BandReadHandler readHandler = new BandReadHandler(new Band());
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    @Override
    protected void doneParsing() throws SAXException {
        int i;
        super.doneParsing();
        Band band = (Band)this.getElement();
        for (i = 0; i < this.elementHandlers.size(); ++i) {
            ElementReadHandler readHandler = (ElementReadHandler)((Object)this.elementHandlers.get(i));
            band.addElement(readHandler.getElement());
        }
        for (i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            StyleExpressionHandler handler = (StyleExpressionHandler)((Object)this.styleExpressionHandlers.get(i));
            StyleKey key = handler.getKey();
            if (handler.getKey() == null) continue;
            Expression expression = handler.getExpression();
            band.setStyleExpression(key, expression);
        }
    }
}

