/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ObjectFactoryUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BasicObjectReadHandler
extends AbstractPropertyXmlReadHandler {
    private ObjectDescription objectDescription;
    private PropertyStringReadHandler stringReadHandler = new PropertyStringReadHandler();
    private ClassFactory classFactory;

    public BasicObjectReadHandler(ObjectDescription objectDescription) {
        this.objectDescription = objectDescription;
    }

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        this.classFactory = (ClassFactory)this.getRootHandler().getHelperObject("::class-factory");
    }

    protected ObjectDescription getObjectDescription() {
        return this.objectDescription;
    }

    protected void setObjectDescription(ObjectDescription objectDescription) {
        this.objectDescription = objectDescription;
    }

    protected ClassFactory getClassFactory() {
        return this.classFactory;
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        this.handleStartParsing(attrs);
        this.getRootHandler().delegate((XmlReadHandler)this.stringReadHandler, this.getUri(), this.getTagName(), (Attributes)attrs);
    }

    protected void handleStartParsing(Attributes attrs) throws ParseException {
        String name = attrs.getValue(this.getUri(), "name");
        if (name == null) {
            throw new ParseException("Required attribute 'name' is missing.", this.getLocator());
        }
        String attrClass = CompatibilityMapperUtil.mapClassName(attrs.getValue(this.getUri(), "class"));
        if (attrClass != null) {
            try {
                ClassLoader loader = ObjectUtilities.getClassLoader(BasicObjectReadHandler.class);
                Class<?> clazz = Class.forName(attrClass, false, loader);
                this.objectDescription = ObjectFactoryUtility.findDescription(this.classFactory, clazz, this.getLocator());
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Value for given 'class' attribute is invalid", this.getLocator());
            }
        }
    }

    protected void doneParsing() throws SAXException {
        String value = this.stringReadHandler.getResult();
        this.objectDescription.setParameter("value", value);
        super.doneParsing();
    }

    public Object getObject() {
        this.objectDescription.configure((Configuration)this.getRootHandler().getParserConfiguration());
        return this.objectDescription.createObject();
    }
}

