/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class DataFactoryWriter
extends AbstractXMLDefinitionWriter {
    private static final String PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.handler.datafactories.";

    public DataFactoryWriter(ReportWriterContext reportWriter, XmlWriter xmlWriter) {
        super(reportWriter, xmlWriter);
    }

    @Override
    public void write() throws IOException, ReportWriterException {
        AbstractReportDefinition reportDef = this.getReport();
        if (!(reportDef instanceof MasterReport)) {
            return;
        }
        MasterReport report = (MasterReport)this.getReport();
        DataFactory dataFactory = report.getDataFactory();
        DataFactoryWriteHandler handler = DataFactoryWriter.lookupWriteHandler(dataFactory);
        if (handler != null) {
            handler.write(this.getReportWriter(), this.getXmlWriter(), dataFactory);
            return;
        }
        DataFactoryWriter.writeDefaultDataFactory(dataFactory, this.getXmlWriter());
    }

    public static DataFactoryWriteHandler lookupWriteHandler(DataFactory dataFactory) {
        String configKey = PREFIX + dataFactory.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null) {
            return (DataFactoryWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, DataFactoryWriter.class, DataFactoryWriteHandler.class);
        }
        return null;
    }

    public static void writeDefaultDataFactory(DataFactory dataFactory, XmlWriter writer) throws IOException {
        String dataFactoryClass = null;
        if (dataFactory != null && DataFactoryWriter.hasPublicDefaultConstructor(dataFactory.getClass())) {
            dataFactoryClass = dataFactory.getClass().getName();
        }
        if (dataFactoryClass == null) {
            return;
        }
        AttributeList attr = new AttributeList();
        attr.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "type", dataFactoryClass);
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "data-factory", attr, true);
    }
}

