/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.states.DefaultGroupingState;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.ExpressionEventHelper;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorageBackend;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeHandler;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.config.Configuration;

public final class ExpressionDataRow
extends ExpressionEventHelper {
    private static final Log logger = LogFactory.getLog(ExpressionDataRow.class);
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private MasterDataRowChangeHandler masterRowChangeHandler;
    private MasterDataRow masterRow;
    private ProcessingContext processingContext;
    private int length;
    private Expression[] expressions;
    private LevelStorageBackend[] levelData;
    private DataRowRuntime runtime;
    private boolean includeStructuralProcessing;

    public ExpressionDataRow(MasterDataRowChangeHandler masterRowChangeHandler, MasterDataRow masterRow, ProcessingContext processingContext) {
        if (masterRow == null) {
            throw new NullPointerException();
        }
        if (processingContext == null) {
            throw new NullPointerException();
        }
        this.processingContext = processingContext;
        this.masterRow = masterRow;
        this.masterRowChangeHandler = masterRowChangeHandler;
        this.expressions = EMPTY_EXPRESSIONS;
        this.runtime = new DataRowRuntime(this);
        this.revalidate();
    }

    public boolean isIncludeStructuralProcessing() {
        return this.includeStructuralProcessing;
    }

    public void setIncludeStructuralProcessing(boolean includeStructuralProcessing) {
        this.includeStructuralProcessing = includeStructuralProcessing;
        this.revalidate();
    }

    private void revalidate() {
        this.levelData = LevelStorageBackend.revalidate(this.expressions, this.length, this.includeStructuralProcessing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionDataRow(MasterDataRowChangeHandler masterRowChangeHandler, MasterDataRow masterRow, ExpressionDataRow previousRow, boolean updateGlobalView) throws CloneNotSupportedException {
        MasterDataRowChangeEvent chEvent = masterRowChangeHandler.getReusableEvent();
        chEvent.reuse(3, "", "");
        this.processingContext = previousRow.processingContext;
        this.masterRow = masterRow;
        this.masterRowChangeHandler = masterRowChangeHandler;
        this.expressions = new Expression[previousRow.expressions.length];
        this.length = previousRow.length;
        this.levelData = previousRow.levelData;
        this.runtime = new DataRowRuntime(this);
        this.runtime.setState(previousRow.runtime.getState());
        this.includeStructuralProcessing = previousRow.includeStructuralProcessing;
        for (int i = 0; i < this.length; ++i) {
            Object value;
            Expression expression = previousRow.expressions[i];
            if (expression == null) {
                logger.debug((Object)"Error: Expression is null...");
                throw new IllegalStateException();
            }
            this.expressions[i] = expression instanceof Function ? (Expression)expression.clone() : expression;
            if (!updateGlobalView) continue;
            String name = expression.getName();
            if (name != null) {
                chEvent.setColumnName(name);
            }
            ExpressionRuntime oldRuntime = expression.getRuntime();
            try {
                expression.setRuntime(this.runtime);
                value = this.runtime.getProcessingContext().getProcessingLevel() <= expression.getDependencyLevel() ? expression.getValue() : null;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("Failed to evaluate expression '" + name + '\''), (Throwable)e);
                } else {
                    logger.warn((Object)("Failed to evaluate expression '" + name + '\''));
                }
                value = null;
            }
            finally {
                expression.setRuntime(oldRuntime);
            }
            if (name == null) continue;
            chEvent.setColumnValue(value);
            masterRowChangeHandler.dataRowChanged(chEvent);
        }
    }

    private void pushExpression(Expression expressionSlot, boolean preserveState) throws ReportProcessingException {
        if (expressionSlot == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + 1);
        if (!preserveState) {
            this.expressions[this.length] = expressionSlot.getInstance();
        } else {
            try {
                this.expressions[this.length] = (Expression)expressionSlot.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ReportProcessingException("Failed to clone the expression.", e);
            }
        }
        String name = expressionSlot.getName();
        ++this.length;
        if (name != null) {
            MasterDataRowChangeEvent event = this.masterRowChangeHandler.getReusableEvent();
            event.reuse(1, name, null);
            this.masterRowChangeHandler.dataRowChanged(event);
        }
    }

    public void pushExpressions(Expression[] expressionSlots, boolean preserveState) throws ReportProcessingException {
        if (expressionSlots == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.length + expressionSlots.length);
        for (int i = 0; i < expressionSlots.length; ++i) {
            Expression expression = expressionSlots[i];
            if (expression == null) continue;
            this.pushExpression(expression, preserveState);
        }
        this.revalidate();
    }

    public void popExpressions(int counter) {
        for (int i = 0; i < counter; ++i) {
            this.popExpression();
        }
        this.revalidate();
    }

    private void popExpression() {
        if (this.length == 0) {
            return;
        }
        Expression removedExpression = this.expressions[this.length - 1];
        String originalName = removedExpression.getName();
        removedExpression.setRuntime(null);
        this.expressions[this.length - 1] = null;
        --this.length;
        if (originalName != null && !removedExpression.isPreserve()) {
            MasterDataRowChangeEvent event = this.masterRowChangeHandler.getReusableEvent();
            event.reuse(2, originalName, null);
            this.masterRowChangeHandler.dataRowChanged(event);
        }
    }

    private void ensureCapacity(int requestedSize) {
        int capacity = this.expressions.length;
        if (capacity > requestedSize) {
            return;
        }
        int newSize = Math.max(capacity * 2, requestedSize + 10);
        Expression[] newExpressions = new Expression[newSize];
        System.arraycopy(this.expressions, 0, newExpressions, 0, this.length);
        this.expressions = newExpressions;
    }

    public int getColumnCount() {
        return this.length;
    }

    @Override
    public void fireReportEvent(ReportEvent event) {
        ReportState reportState = event.getState();
        this.runtime.setState(reportState.createGroupingState());
        this.runtime.setCrosstabInfo(reportState.isStructuralPreprocessingNeeded(), reportState.isCrosstabActive());
        super.fireReportEvent(event);
        super.reactivateExpressions(event.isDeepTraversing());
    }

    @Override
    protected void updateMasterDataRow(String name, Object value) {
        MasterDataRowChangeEvent event = this.masterRowChangeHandler.getReusableEvent();
        event.reuse(3, name, value);
        this.masterRowChangeHandler.dataRowChanged(event);
    }

    @Override
    protected ExpressionRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    protected int getProcessingLevel() {
        int rawLevel = this.runtime.getProcessingContext().getProcessingLevel();
        int activeLevel = rawLevel == Integer.MAX_VALUE ? (this.levelData.length > 0 ? this.levelData[0].getLevelNumber() : rawLevel) : rawLevel;
        return activeLevel;
    }

    public ExpressionDataRow derive(MasterDataRowChangeHandler masterRowChangeHandler, MasterDataRow masterRow, boolean update) {
        try {
            return new ExpressionDataRow(masterRowChangeHandler, masterRow, this, update);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Error on derive(..): ", (Throwable)e);
            throw new IllegalStateException("Cannot clone? Cannot survive!");
        }
    }

    public boolean isValid() {
        return this.levelData != null;
    }

    public Expression[] getExpressions() {
        Expression[] retval = new Expression[this.length];
        System.arraycopy(this.expressions, 0, retval, 0, this.length);
        return retval;
    }

    protected MasterDataRow getMasterRow() {
        return this.masterRow;
    }

    protected ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public void refresh() {
        this.reactivateExpressions(false);
    }

    @Override
    protected int getRunLevelCount() {
        return this.levelData.length;
    }

    @Override
    protected LevelStorage getRunLevel(int index) {
        LevelStorageBackend backend = this.levelData[index];
        return LevelStorageBackend.getLevelStorage(backend, this.expressions);
    }

    private static class DataRowRuntime
    implements ExpressionRuntime {
        private ExpressionDataRow expressionDataRow;
        private GroupingState state;
        private boolean structuralComplex;
        private boolean crosstabActive;

        protected DataRowRuntime(ExpressionDataRow dataRow) {
            this.expressionDataRow = dataRow;
            this.state = DefaultGroupingState.EMPTY;
        }

        @Override
        public DataSchema getDataSchema() {
            return this.expressionDataRow.getMasterRow().getDataSchema();
        }

        @Override
        public DataRow getDataRow() {
            return this.expressionDataRow.getMasterRow().getGlobalView();
        }

        @Override
        public Configuration getConfiguration() {
            return this.getProcessingContext().getConfiguration();
        }

        @Override
        public ResourceBundleFactory getResourceBundleFactory() {
            return this.expressionDataRow.getMasterRow().getResourceBundleFactory();
        }

        @Override
        public DataFactory getDataFactory() {
            return this.expressionDataRow.getMasterRow().getDataFactory();
        }

        @Override
        public TableModel getData() {
            return this.expressionDataRow.getMasterRow().getReportData();
        }

        @Override
        public int getCurrentRow() {
            return this.expressionDataRow.getMasterRow().getCursor();
        }

        @Override
        public int getCurrentDataItem() {
            return this.expressionDataRow.getMasterRow().getRawDataCursor();
        }

        @Override
        public String getExportDescriptor() {
            return this.getProcessingContext().getExportDescriptor();
        }

        @Override
        public ProcessingContext getProcessingContext() {
            return this.expressionDataRow.getProcessingContext();
        }

        @Override
        public int getCurrentGroup() {
            return this.state.getCurrentGroup();
        }

        @Override
        public int getGroupStartRow(String groupName) {
            return this.state.getGroupStartRow(groupName);
        }

        @Override
        public int getGroupStartRow(int groupIndex) {
            return this.state.getGroupStartRow(groupIndex);
        }

        @Override
        public boolean isStructuralComplexReport() {
            return this.structuralComplex;
        }

        @Override
        public boolean isCrosstabActive() {
            return this.crosstabActive;
        }

        public GroupingState getState() {
            return this.state;
        }

        public void setState(GroupingState state) {
            if (state == null) {
                throw new NullPointerException();
            }
            this.state = state;
        }

        public void setCrosstabInfo(boolean structuralComplex, boolean crosstabActive) {
            this.structuralComplex = structuralComplex;
            this.crosstabActive = crosstabActive;
        }
    }
}

