/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.libraries.base.util.EmptyIterator;

public class StructureFunctionLevelStorage
implements LevelStorage,
Iterator<Function> {
    private int level;
    private boolean[] pageListener;
    private Function[] outputFunction;
    private int cursor;
    private boolean searchPageListeners;

    public StructureFunctionLevelStorage(int level, Function[] outputFunction, boolean[] pageListener) {
        if (outputFunction == null) {
            throw new NullPointerException();
        }
        this.level = level;
        this.pageListener = pageListener;
        this.outputFunction = outputFunction;
    }

    @Override
    public int getLevelNumber() {
        return this.level;
    }

    @Override
    public Iterator<Function> getFunctions() {
        this.cursor = 0;
        this.searchPageListeners = false;
        return this;
    }

    @Override
    public Iterator<Function> getPageFunctions() {
        this.cursor = -1;
        this.cursor = this.findNextIndex();
        this.searchPageListeners = true;
        return this;
    }

    private int findNextIndex() {
        if (!this.searchPageListeners) {
            return this.cursor + 1;
        }
        while (this.cursor < this.outputFunction.length) {
            ++this.cursor;
            if (this.cursor >= this.outputFunction.length || !this.pageListener[this.cursor]) continue;
            break;
        }
        return this.outputFunction.length;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.outputFunction.length;
    }

    @Override
    public Function next() {
        if (!(this.cursor < this.outputFunction.length)) {
            throw new IllegalStateException();
        }
        Function retval = this.outputFunction[this.cursor];
        this.cursor = this.findNextIndex();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Expression> getActiveExpressions() {
        return EmptyIterator.emptyIterator();
    }
}

